<?php

namespace Database\Seeders;

use App\Events\Backend\UserCreated;
use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use App\Models\User;
use App\Models\ProviderAddressMapping;
use App\Models\ProviderZoneMapping;

class UsersTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {

        if (env('IS_DUMMY_DATA') == true) {

            $data = [
                [
                    'id' => 1,
                    'username' => 'admin',
                    'first_name' => 'Super',
                    'last_name' => 'Admin',
                    'email' => 'admin@admin.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'admin',
                    'contact_number' => '9876543210',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10839,
                    'provider_id' => NULL,
                    'address' => 'Melville, SK, Canada',
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Super Admin',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-09-29 07:47:07',
                    'email_verified_at' => NULL,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2021-05-28 15:59:15',
                    'updated_at' => '2023-10-03 09:52:48',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/admin/super_admin.png'),
                ],
                [
                    'id' => 2,
                    'username' => 'demo_admin',
                    'first_name' => 'Demo',
                    'last_name' => 'Admin',
                    'email' => 'demo@admin.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'demo_admin',
                    'contact_number' => '4564552664',
                    'country_id' => 231,
                    'state_id' => 3924,
                    'city_id' => 42865,
                    'provider_id' => NULL,
                    'address' => NULL,
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Demo Admin',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2021-05-29 05:40:38',
                    'updated_at' => NULL,
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/admin/demo_admin.png'),
                ],
                [
                    'id' => 3,
                    'username' => 'pedro_norris',
                    'first_name' => 'Pedro',
                    'last_name' => 'Norris',
                    'email' => 'demo@user.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-56781289',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => NULL,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Pedro Norris',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2021-05-28 12:36:58',
                    'updated_at' => '2023-09-12 05:31:58',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/pedro.png'),
                ],
                [
                    'id' => 4,
                    'username' => 'felix_harris',
                    'first_name' => 'Felix',
                    'last_name' => 'Harris',
                    'email' => 'demo@provider.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-81289567',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => NULL,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Felix Harris',
                    'providertype_id' => 1,
                    'is_featured' => 1,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-09-22 13:36:32',
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2021-05-29 05:43:47',
                    'updated_at' => '2023-09-22 13:36:32',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 1,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => '["English","Spanish","French"]',
                    'skills' => '[]',
                    'description' => "My work is not just a job, but a lifelong passion. With years of experience, I've refined my skills and honed my craft to provide top-quality service to my clients. 😍",
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/felix.png'),
                    'provider_address' => [
                        [
                            'id' => 1,
                            'provider_id' => 4,
                            'address' => 'North Battleford, SK, Canada',
                            'latitude' => '52.757500',
                            'longitude' => '-108.286110',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:15:18',
                            'updated_at' => '2023-09-04 06:15:18',
                            'deleted_at' => NULL
                        ],
                        [
                            'id' => 2,
                            'provider_id' => 4,
                            'address' => 'Melville, SK, Canada',
                            'latitude' => '50.930557',
                            'longitude' => '-102.807777',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:15:46',
                            'updated_at' => '2023-09-04 06:15:46',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 3,
                            'provider_id' => 4,
                            'address' => 'Ashland, KY, USA',
                            'latitude' => '38.460304',
                            'longitude' => '-82.649666',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:16:14',
                            'updated_at' => '2023-09-04 06:16:14',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 4,
                            'provider_id' => 4,
                            'address' => 'Mont-Saint-Hilaire, QC, Canada',
                            'latitude' => '45.562222',
                            'longitude' => '-73.191666',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:16:49',
                            'updated_at' => '2023-09-04 06:16:49',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 5,
                            'provider_id' => 4,
                            'address' => 'Melbourne, Australia',
                            'latitude' => '-37.8142',
                            'longitude' => '144.9631',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:17:11',
                            'updated_at' => '2023-09-04 06:36:55',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 6,
                            'provider_id' => 4,
                            'address' => 'Brisbane, Australia',
                            'latitude' => '-27.4678',
                            'longitude' => '153.0281',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:17:36',
                            'updated_at' => '2023-09-04 06:17:36',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 7,
                            'provider_id' => 4,
                            'address' => 'Yorkton, SK, Canada',
                            'latitude' => '51.213890',
                            'longitude' => '102.462776',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:18:08',
                            'updated_at' => '2023-09-04 06:18:08',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 8,
                            'provider_id' => 4,
                            'address' => 'Morgan City, LA, USA',
                            'latitude' => '29.706043',
                            'longitude' => '-91.206917',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:18:37',
                            'updated_at' => '2023-09-04 06:18:37',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 10,
                            'provider_id' => 4,
                            'address' => 'Hazard, KY, USA',
                            'latitude' => '37.250626',
                            'longitude' => '-83.195503',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:19:25',
                            'updated_at' => '2023-09-04 06:19:25',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 31,
                            'provider_id' => 4,
                            'address' => 'Southampton, UK',
                            'latitude' => '50.909698',
                            'longitude' => '-1.404351',
                            'status' => 1,
                            'created_at' => '2023-09-06 11:08:15',
                            'updated_at' => '2023-09-06 11:08:15',
                            'deleted_at' => NULL,
                        ]
                    ],

                    'provider_zone' => [1, 2, 3, 4, 5, 6, 7]


                ],
                [
                    'id' => 6,
                    'username' => 'andrew_rhodes',
                    'first_name' => 'Andrew',
                    'last_name' => 'Rhodes',
                    'email' => 'andrew@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-8783783872',
                    'country_id' => 231,
                    'state_id' => 3938,
                    'city_id' => 44580,
                    'provider_id' => NULL,
                    'address' => 'Covington, KY, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Andrew Rhodes',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-01 13:21:24',
                    'updated_at' => '2023-10-06 05:52:20',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/andrew.png'),
                    'provider_address' => [
                        [
                            'id' => 11,
                            'provider_id' => 6,
                            'address' => 'Covington, KY, USA',
                            'latitude' => '39.067719',
                            'longitude' => '-84.516426',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:22:55',
                            'updated_at' => '2023-09-04 06:22:55',
                            'deleted_at' => NULL,
                        ]
                    ],
                ],
                [
                    'id' => 7,
                    'username' => 'jennifer_perez',
                    'first_name' => 'Jennifer',
                    'last_name' => 'Davis',
                    'email' => 'jennifer@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '44-5874968574',
                    'country_id' => 230,
                    'state_id' => 3810,
                    'city_id' => 41414,
                    'provider_id' => NULL,
                    'address' => 'Belfast, UK',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Jennifer Davis',
                    'providertype_id' => 2,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-01 13:24:13',
                    'updated_at' => '2023-09-29 05:49:13',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/jennifer.png'),
                    'provider_address' => [
                        [
                            'id' => 12,
                            'provider_id' => 7,
                            'address' => 'Belfast, UK',
                            'latitude' => '54.607868',
                            'longitude' => '-5.926437',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:24:44',
                            'updated_at' => '2023-09-04 06:24:54',
                            'deleted_at' => '2023-09-04 06:24:54',
                        ],
                        [
                            'id' => 13,
                            'provider_id' => 7,
                            'address' => 'Belfast, UK',
                            'latitude' => '54.607868',
                            'longitude' => '-5.926437',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:25:16',
                            'updated_at' => '2023-09-04 06:25:16',
                            'deleted_at' => NULL,
                        ]
                    ],
                ],
                [
                    'id' => 8,
                    'username' => 'danny_mark',
                    'first_name' => 'Danny',
                    'last_name' => 'Mark',
                    'email' => 'danny@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-66755245',
                    'country_id' => 231,
                    'state_id' => 3942,
                    'city_id' => 44771,
                    'provider_id' => NULL,
                    'address' => 'Cambridge, MD, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Danny Mark',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 05:29:53',
                    'updated_at' => '2023-09-30 07:11:39',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/danny.png'),
                    'provider_address' => [
                        [
                            'id' => 14,
                            'provider_id' => 8,
                            'address' => 'Cambridge, MD, USA',
                            'latitude' => '38.563461',
                            'longitude' => '-76.085251',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:26:23',
                            'updated_at' => '2023-09-04 06:26:23',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [3]
                ],
                [
                    'id' => 9,
                    'username' => 'kahlil_graham',
                    'first_name' => 'Kahlil',
                    'last_name' => 'Graham',
                    'email' => 'kahil@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-5896547896',
                    'country_id' => 231,
                    'state_id' => 3941,
                    'city_id' => 44709,
                    'provider_id' => NULL,
                    'address' => 'Augusta, ME, USA',
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Kahlil Graham',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 05:33:47',
                    'updated_at' => '2023-09-04 06:28:41',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/kahil.png'),
                    'provider_address' => [
                        [
                            'id' => 15,
                            'provider_id' => 9,
                            'address' => 'Augusta, ME, USA',
                            'latitude' => '44.331493',
                            'longitude' => '-69.788994',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:28:23',
                            'updated_at' => '2023-09-04 06:28:23',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [2]
                ],
                [
                    'id' => 10,
                    'username' => 'beverly_mendiz',
                    'first_name' => 'Beverly',
                    'last_name' => 'Mendiz',
                    'email' => 'beverly@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-5285967485',
                    'country_id' => 231,
                    'state_id' => 3941,
                    'city_id' => 44708,
                    'provider_id' => NULL,
                    'address' => 'Auburn, MD, USA',
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Beverly Mendiz',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 05:36:49',
                    'updated_at' => '2023-09-04 06:31:15',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/beverly.png'),
                    'provider_address' => [
                        [
                            'id' => 16,
                            'provider_id' => 10,
                            'address' => 'Aberdeen, MD, USA',
                            'latitude' => '39.514877',
                            'longitude' => '-76.174110',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:30:48',
                            'updated_at' => '2023-09-04 06:30:48',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 17,
                            'provider_id' => 10,
                            'address' => 'Auburn, MD, USA',
                            'latitude' => '32.609856',
                            'longitude' => '-85.480782',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:31:18',
                            'updated_at' => '2023-09-04 06:31:18',
                            'deleted_at' => NULL,
                        ]

                    ],
                    'provider_zone' => [7]
                ],
                [
                    'id' => 12,
                    'username' => 'erik_simon',
                    'first_name' => 'Erik',
                    'last_name' => 'Simon',
                    'email' => 'erik@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-6674859612',
                    'country_id' => 38,
                    'state_id' => 671,
                    'city_id' => 10269,
                    'provider_id' => NULL,
                    'address' => 'Ontario, Barrie, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Erik Simon',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 05:49:50',
                    'updated_at' => '2023-09-29 09:35:05',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/erik.png'),
                    'provider_address' => [
                        [
                            'id' => 20,
                            'provider_id' => 12,
                            'address' => 'Sandy Beach, Canada',
                            'latitude' => '-30.1483',
                            'longitude' => '153.2011',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:38:25',
                            'updated_at' => '2023-09-04 06:38:25',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 21,
                            'provider_id' => 12,
                            'address' => 'Ontario, Barrie, Canada',
                            'latitude' => '44.389355',
                            'longitude' => '-79.690331',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:40:56',
                            'updated_at' => '2023-09-04 06:40:56',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [4]
                ],
                [
                    'id' => 13,
                    'username' => 'ricahard_gross',
                    'first_name' => 'Ricahard',
                    'last_name' => 'Gross',
                    'email' => 'richard@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-6678454698',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10859,
                    'provider_id' => NULL,
                    'address' => 'Warman, SK, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Ricahard Gross',
                    'providertype_id' => 2,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 05:55:16',
                    'updated_at' => '2023-09-29 07:59:44',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/richard.png'),
                    'provider_address' => [
                        [
                            'id' => 22,
                            'provider_id' => 13,
                            'address' => 'Warman, SK, Canada',
                            'latitude' => '52.321945',
                            'longitude' => '-106.584167',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:42:23',
                            'updated_at' => '2023-09-04 06:42:23',
                            'deleted_at' => NULL,
                        ],
                    ],
                    'provider_zone' => [1]
                ],
                [
                    'id' => 14,
                    'username' => 'venesa_shaw',
                    'first_name' => 'Venesa',
                    'last_name' => 'Shaw',
                    'email' => 'venesa@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '61-85749687',
                    'country_id' => 13,
                    'state_id' => 265,
                    'city_id' => 6571,
                    'provider_id' => NULL,
                    'address' => 'Melbourne, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Venesa Shaw',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 05:58:02',
                    'updated_at' => '2023-09-29 08:32:19',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => json_encode([
                        "title" => "Your Trusted Service Partner for Hassle-Free, Reliable, and On-Time Solutions",
                        "about_description" => "With over 10 years of experience in the service industry...",
                        "reason" => [
                            "Quick and reliable service",
                            "High customer satisfaction rate",
                            "Flexible scheduling to fit your needs"
                        ],
                    ]),
                    'profile_image' => public_path('/images/profile-images/provider/venesa.png'),
                    'provider_address' => [
                        [
                            'id' => 23,
                            'provider_id' => 14,
                            'address' => 'Melbourne, Australia',
                            'latitude' => '-37.8142',
                            'longitude' => '144.9631',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:43:16',
                            'updated_at' => '2023-09-04 06:43:16',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 24,
                            'provider_id' => 14,
                            'address' => 'Sydney, Australia',
                            'latitude' => '-33.8678',
                            'longitude' => '151.2100',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:44:38',
                            'updated_at' => '2023-09-04 06:44:38',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [6]
                ],
                [
                    'id' => 15,
                    'username' => 'jorge_perez',
                    'first_name' => 'Jorge',
                    'last_name' => 'Perez',
                    'email' => 'jorge@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-857485745',
                    'country_id' => 231,
                    'state_id' => 3943,
                    'city_id' => 44996,
                    'provider_id' => NULL,
                    'address' => 'New Bedford, MA, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Jorge Perez',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 06:00:05',
                    'updated_at' => '2023-09-19 06:43:11',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/jorge.png'),
                    'provider_address' => [
                        [
                            'id' => 25,
                            'provider_id' => 15,
                            'address' => 'New Bedford, MA, USA',
                            'latitude' => '41.638409',
                            'longitude' => '-70.941208',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:46:26',
                            'updated_at' => '2023-09-04 06:46:26',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 26,
                            'provider_id' => 15,
                            'address' => 'Greenbelt, MD, USA',
                            'latitude' => '38.998318',
                            'longitude' => '-76.896332',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:46:53',
                            'updated_at' => '2023-09-04 06:46:53',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [3, 6]
                ],
                [
                    'id' => 16,
                    'username' => 'daniel_wiliams',
                    'first_name' => 'Daniel',
                    'last_name' => 'Wiliams',
                    'email' => 'daniel@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '63-98512454',
                    'country_id' => 13,
                    'state_id' => 273,
                    'city_id' => 6745,
                    'provider_id' => NULL,
                    'address' => 'Frankston, Victoria, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Daniel Wiliams',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 06:05:25',
                    'updated_at' => '2023-09-29 09:08:06',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/daniel.png'),
                    'provider_address' => [
                        [
                            'id' => 27,
                            'provider_id' => 16,
                            'address' => 'Newcastle, Australia',
                            'latitude' => '-32.9167',
                            'longitude' => '151.7500',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:48:59',
                            'updated_at' => '2023-09-04 06:48:59',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 28,
                            'provider_id' => 16,
                            'address' => 'Frankston, Victoria, Australia',
                            'latitude' => '-38.1580',
                            'longitude' => '145.1350',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:50:11',
                            'updated_at' => '2023-09-04 06:50:11',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [5]
                ],
                [
                    'id' => 17,
                    'username' => 'katie_brown',
                    'first_name' => 'Katie',
                    'last_name' => 'Brown',
                    'email' => 'katie@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '44-85748545',
                    'country_id' => 230,
                    'state_id' => 3889,
                    'city_id' => 42382,
                    'provider_id' => NULL,
                    'address' => 'Edinburgh, Scotland, UK',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Katie Brown',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 06:10:38',
                    'updated_at' => '2023-09-27 11:52:11',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => 'Manager',
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/katie.png'),
                    'provider_address' => [
                        [
                            'id' => 29,
                            'provider_id' => 17,
                            'address' => 'Edinburgh, Scotland, UK',
                            'latitude' => '55.953251',
                            'longitude' => '-3.188267',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:51:33',
                            'updated_at' => '2023-09-04 06:51:33',
                            'deleted_at' => NULL,
                        ],
                        [
                            'id' => 30,
                            'provider_id' => 17,
                            'address' => 'Elgin, Scotland, UK',
                            'latitude' => '57.653484',
                            'longitude' => '-3.335724',
                            'status' => 1,
                            'created_at' => '2023-09-04 06:52:44',
                            'updated_at' => '2023-09-04 06:52:44',
                            'deleted_at' => NULL,
                        ]
                    ],
                    'provider_zone' => [1]
                ],
                [
                    'id' => 18,
                    'username' => 'koech_bena',
                    'first_name' => 'Koech',
                    'last_name' => 'Bena',
                    'email' => 'koech@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-66748598',
                    'country_id' => 38,
                    'state_id' => 665,
                    'city_id' => 10206,
                    'provider_id' => 13,
                    'address' => 'Manitoba, Carberry, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Koech Bena',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 07:05:57',
                    'updated_at' => '2023-10-02 15:11:03',
                    'login_type' => NULL,
                    'service_address_id' => 22,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '15:11:03',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/koech.png'),
                ],
                [
                    'id' => 19,
                    'username' => 'hayden_norman',
                    'first_name' => 'Hayden',
                    'last_name' => 'Norman',
                    'email' => 'hayden@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '61-85725623',
                    'country_id' => 13,
                    'state_id' => 245,
                    'city_id' => 6555,
                    'provider_id' => 14,
                    'address' => 'Melbourne, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Hayden Norman',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 10:42:50',
                    'updated_at' => '2023-10-06 14:58:29',
                    'login_type' => NULL,
                    'service_address_id' => 23,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '14:58:29',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/hayden.png'),
                ],
                [
                    'id' => 20,
                    'username' => 'robert_martin',
                    'first_name' => 'Robert',
                    'last_name' => 'Martin',
                    'email' => 'robertmartin@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-56235263',
                    'country_id' => 231,
                    'state_id' => 3943,
                    'city_id' => 44996,
                    'provider_id' => 15,
                    'address' => 'New Bedford, MA, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Robert Martin',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 10:50:17',
                    'updated_at' => '2023-10-02 18:34:45',
                    'login_type' => NULL,
                    'service_address_id' => 25,
                    'uid' => NULL,
                    'handymantype_id' => 2,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '18:34:45',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/robertMartin.png'),
                ],
                [
                    'id' => 21,
                    'username' => 'liam_long',
                    'first_name' => 'Liam',
                    'last_name' => 'Long',
                    'email' => 'liam@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-47859652',
                    'country_id' => 231,
                    'state_id' => 3942,
                    'city_id' => 44819,
                    'provider_id' => 15,
                    'address' => 'Greenbelt, MD, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Liam Long',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 10:52:38',
                    'updated_at' => '2023-10-06 15:31:14',
                    'login_type' => NULL,
                    'service_address_id' => 26,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '15:31:14',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/liam.png'),
                ],
                [
                    'id' => 22,
                    'username' => 'bentley_howard',
                    'first_name' => 'Bentley',
                    'last_name' => 'Howard',
                    'email' => 'bentley@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '63-41522536',
                    'country_id' => 13,
                    'state_id' => 273,
                    'city_id' => 6745,
                    'provider_id' => 16,
                    'address' => 'Frankston, Victoria, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Bentley Howard',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 10:55:54',
                    'updated_at' => '2023-10-02 17:04:55',
                    'login_type' => NULL,
                    'service_address_id' => 28,
                    'uid' => NULL,
                    'handymantype_id' => 2,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '17:04:55',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/bentley.png'),
                ],
                [
                    'id' => 23,
                    'username' => 'gilbert_adams',
                    'first_name' => 'Gilbert',
                    'last_name' => 'Adams',
                    'email' => 'gilbert@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '63-85885698',
                    'country_id' => 13,
                    'state_id' => 273,
                    'city_id' => 6745,
                    'provider_id' => 16,
                    'address' => 'Frankston, Victoria, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Gilbert Adams',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 10:59:03',
                    'updated_at' => '2023-10-02 17:12:42',
                    'login_type' => NULL,
                    'service_address_id' => 28,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '17:12:42',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/gilbert.png'),
                ],
                [
                    'id' => 24,
                    'username' => 'erica_thomas',
                    'first_name' => 'Erica',
                    'last_name' => 'Thomas',
                    'email' => 'ericathomas@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '44-77885877',
                    'country_id' => 230,
                    'state_id' => 3889,
                    'city_id' => 42382,
                    'provider_id' => 17,
                    'address' => 'Edinburgh, Scotland, UK',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Erica Thomas',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-09-12 05:58:50',
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:02:15',
                    'updated_at' => '2023-09-30 19:25:25',
                    'login_type' => NULL,
                    'service_address_id' => 29,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '19:25:25',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/ericaThomas.png'),
                ],
                [
                    'id' => 25,
                    'username' => 'harry_victoria',
                    'first_name' => 'Harry',
                    'last_name' => 'Victoria',
                    'email' => 'harry@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-85748574',
                    'country_id' => 38,
                    'state_id' => 671,
                    'city_id' => 10269,
                    'provider_id' => 12,
                    'address' => 'Ontario, Barrie, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Harry Victoria',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:06:16',
                    'updated_at' => '2023-10-02 18:50:11',
                    'login_type' => NULL,
                    'service_address_id' => 21,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '18:50:11',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/harry.png'),
                ],
                [
                    'id' => 26,
                    'username' => 'marry_kom',
                    'first_name' => 'Marry',
                    'last_name' => 'Kom',
                    'email' => 'marry@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-44523652',
                    'country_id' => 231,
                    'state_id' => 3942,
                    'city_id' => 44771,
                    'provider_id' => 8,
                    'address' => 'Cambridge, MD, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Marry Kom',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:09:24',
                    'updated_at' => '2023-10-02 11:39:39',
                    'login_type' => NULL,
                    'service_address_id' => 14,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '11:39:39',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/marry.png'),
                ],
                [
                    'id' => 27,
                    'username' => 'stephen_richey',
                    'first_name' => 'Stephen',
                    'last_name' => 'Richey',
                    'email' => 'stephen@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '44-75586251',
                    'country_id' => 230,
                    'state_id' => 3810,
                    'city_id' => 41414,
                    'provider_id' => 7,
                    'address' => 'Belfast, UK',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Stephen Richey',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:12:07',
                    'updated_at' => '2023-10-02 17:29:15',
                    'login_type' => NULL,
                    'service_address_id' => 13,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '17:29:15',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/stephen.png'),
                ],
                [
                    'id' => 28,
                    'username' => 'robert_benedict',
                    'first_name' => 'Robert',
                    'last_name' => 'Benedict',
                    'email' => 'robertbenedict@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-25526232',
                    'country_id' => 230,
                    'state_id' => 3842,
                    'city_id' => 41928,
                    'provider_id' => 4,
                    'address' => 'Southampton, England, UK',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Robert Benedict',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-10-02 06:02:20',
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:15:09',
                    'updated_at' => '2023-10-02 11:33:48',
                    'login_type' => NULL,
                    'service_address_id' => 1,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '11:33:48',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/robertBenedict.png'),
                ],
                [
                    'id' => 29,
                    'username' => 'leo_newton',
                    'first_name' => 'Leo',
                    'last_name' => 'Newton',
                    'email' => 'leo@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-32326522',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10839,
                    'provider_id' => 4,
                    'address' => 'Melville, SK, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Leo Newton',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:17:01',
                    'updated_at' => '2023-10-02 10:59:09',
                    'login_type' => NULL,
                    'service_address_id' => 2,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '10:59:09',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/leo.png'),
                ],
                [
                    'id' => 30,
                    'username' => 'dan_gordon',
                    'first_name' => 'Dan',
                    'last_name' => 'Gordon',
                    'email' => 'dan@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '61-85956523',
                    'country_id' => 13,
                    'state_id' => 273,
                    'city_id' => 6771,
                    'provider_id' => 4,
                    'address' => 'Melbourne, Victoria, Australia',
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Dan Gordon',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:19:49',
                    'updated_at' => '2023-09-04 11:19:49',
                    'login_type' => NULL,
                    'service_address_id' => 5,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/dan.png'),
                ],
                [
                    'id' => 31,
                    'username' => 'brian_shaw',
                    'first_name' => 'Brian',
                    'last_name' => 'Shaw',
                    'email' => 'brian@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '61-53623325',
                    'country_id' => 13,
                    'state_id' => 269,
                    'city_id' => 6600,
                    'provider_id' => 4,
                    'address' => 'Brisbane, Queensland, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Brian Shaw',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:22:15',
                    'updated_at' => '2023-09-30 11:22:04',
                    'login_type' => NULL,
                    'service_address_id' => 6,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '11:22:04',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/brian.png'),
                ],
                [
                    'id' => 32,
                    'username' => 'ebenzer_tipox',
                    'first_name' => 'Ebenzer',
                    'last_name' => 'Tipox',
                    'email' => 'ebenzer@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-44748566',
                    'country_id' => 231,
                    'state_id' => 3938,
                    'city_id' => 44574,
                    'provider_id' => 4,
                    'address' => 'Ashland, KY, USA',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Ebenzer Tipox',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:56:09',
                    'updated_at' => '2023-10-02 15:02:11',
                    'login_type' => NULL,
                    'service_address_id' => 3,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '15:02:11',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/ebenzer.png'),
                ],
                [
                    'id' => 33,
                    'username' => 'parsa_evana',
                    'first_name' => 'Parsa',
                    'last_name' => 'Evana',
                    'email' => 'parsa@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '61-66589547',
                    'country_id' => 13,
                    'state_id' => 273,
                    'city_id' => 6771,
                    'provider_id' => 4,
                    'address' => 'Melbourne, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Parsa Evana',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-09-30 06:15:16',
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 11:59:59',
                    'updated_at' => '2023-10-02 11:27:28',
                    'login_type' => NULL,
                    'service_address_id' => 5,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '11:27:28',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/parsa.png'),
                ],
                [
                    'id' => 34,
                    'username' => 'erica_mendiz',
                    'first_name' => 'Erica',
                    'last_name' => 'Mendiz',
                    'email' => 'ericamendiz@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '61-33253256',
                    'country_id' => 13,
                    'state_id' => 269,
                    'city_id' => 6600,
                    'provider_id' => 4,
                    'address' => 'Brisbane, Queensland, Australia',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Erica Mendiz',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 12:04:08',
                    'updated_at' => '2023-10-02 15:05:07',
                    'login_type' => NULL,
                    'service_address_id' => 6,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '15:05:07',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/ericaMendiz.png'),
                ],
                [
                    'id' => 35,
                    'username' => 'jacky_sam',
                    'first_name' => 'Jacky',
                    'last_name' => 'Sam',
                    'email' => 'jacky@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-632266589',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10865,
                    'provider_id' => 4,
                    'address' => 'Yorkton, SK, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Jacky Sam',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 12:06:23',
                    'updated_at' => '2023-10-02 15:22:27',
                    'login_type' => NULL,
                    'service_address_id' => 7,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '15:22:27',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/jacky.png'),
                ],
                [
                    'id' => 36,
                    'username' => 'chrysta_ellis',
                    'first_name' => 'Chrysta',
                    'last_name' => 'Ellis',
                    'email' => 'chrysta@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-32525263',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => 4,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'Chrysta Ellis',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-09-30 05:48:47',
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-04 12:15:46',
                    'updated_at' => '2023-10-03 17:53:21',
                    'login_type' => NULL,
                    'service_address_id' => 1,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '17:53:21',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/chrysta.png'),
                ],
                [
                    'id' => 37,
                    'username' => 'david_thomas',
                    'first_name' => 'David',
                    'last_name' => 'Thomas',
                    'email' => 'david@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-45887837',
                    'country_id' => 231,
                    'state_id' => 3938,
                    'city_id' => 44580,
                    'provider_id' => NULL,
                    'address' => 'Covington, KY, USA',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'David Thomas',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 06:11:12',
                    'updated_at' => '2023-10-05 06:44:16',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/david.png'),
                ],
                [
                    'id' => 38,
                    'username' => 'alexa_ellis',
                    'first_name' => 'Alexa',
                    'last_name' => 'Ellis',
                    'email' => 'alexa@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '61-49687857',
                    'country_id' => 13,
                    'state_id' => 265,
                    'city_id' => 6571,
                    'provider_id' => NULL,
                    'address' => 'Melbourne, Australia',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Alexa Ellis',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 06:32:23',
                    'updated_at' => '2023-10-03 11:54:07',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/alexa.png'),
                ],
                [
                    'id' => 39,
                    'username' => 'justin_worn',
                    'first_name' => 'Justin',
                    'last_name' => 'Worn',
                    'email' => 'justin@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-66766455',
                    'country_id' => 231,
                    'state_id' => 3942,
                    'city_id' => 44771,
                    'provider_id' => NULL,
                    'address' => 'Cambridge, MD, USA',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Justin Worn',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 06:48:55',
                    'updated_at' => '2023-10-05 06:11:15',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/justin.png'),
                ],
                [
                    'id' => 40,
                    'username' => 'joseph_harris',
                    'first_name' => 'Joseph',
                    'last_name' => 'Harris',
                    'email' => 'joseph@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-25526232',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => NULL,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Joseph Harris',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 06:57:40',
                    'updated_at' => '2023-10-03 11:52:07',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/joseph.png'),
                ],
                [
                    'id' => 41,
                    'username' => 'sunny_francis',
                    'first_name' => 'Sunny',
                    'last_name' => 'Francis',
                    'email' => 'sunny@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '63-65223232',
                    'country_id' => 13,
                    'state_id' => 273,
                    'city_id' => 6745,
                    'provider_id' => NULL,
                    'address' => 'Frnakston, Victoria, Australia',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Sunny Francis',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 07:11:20',
                    'updated_at' => '2023-10-03 11:55:16',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/sunny.png'),
                ],
                [
                    'id' => 42,
                    'username' => 'tracy_jones',
                    'first_name' => 'Tracy',
                    'last_name' => 'Jones',
                    'email' => 'tracy@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-44748566',
                    'country_id' => 231,
                    'state_id' => 3938,
                    'city_id' => 44574,
                    'provider_id' => NULL,
                    'address' => 'Ashland, KY, USA',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Tracy Jones',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 07:21:59',
                    'updated_at' => '2023-10-03 11:56:18',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/tracy.png'),
                ],
                [
                    'id' => 43,
                    'username' => 'brenda_moody',
                    'first_name' => 'Brenda',
                    'last_name' => 'Moody',
                    'email' => 'brenda@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-632266589',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10865,
                    'provider_id' => NULL,
                    'address' => 'Yorkton, SK, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Brenda Moody',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 10:41:22',
                    'updated_at' => '2023-10-05 08:15:42',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/brenda.png'),
                ],
                [
                    'id' => 44,
                    'username' => 'stella_green',
                    'first_name' => 'Stella',
                    'last_name' => 'Green',
                    'email' => 'stella@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-52625232',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => NULL,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Stella Green',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 10:56:37',
                    'updated_at' => '2023-10-05 10:02:25',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/stella.png'),
                ],
                [
                    'id' => 45,
                    'username' => 'pedra_daniel',
                    'first_name' => 'Pedra',
                    'last_name' => 'Daniel',
                    'email' => 'pedra@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-74885574',
                    'country_id' => 38,
                    'state_id' => 671,
                    'city_id' => 10269,
                    'provider_id' => NULL,
                    'address' => 'Ontario, Barrie, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Pedra Daniel',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 11:49:41',
                    'updated_at' => '2023-10-05 09:57:10',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/pedra.png'),
                ],
                [
                    'id' => 46,
                    'username' => 'milar_green',
                    'first_name' => 'Milar',
                    'last_name' => 'Green',
                    'email' => 'milar@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-85966748',
                    'country_id' => 38,
                    'state_id' => 665,
                    'city_id' => 10206,
                    'provider_id' => NULL,
                    'address' => 'Manitoba, Carberry, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Milar Green',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 12:07:39',
                    'updated_at' => '2023-10-03 13:13:05',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/miller.png'),
                ],
                [
                    'id' => 47,
                    'username' => 'lisa_doe',
                    'first_name' => 'Lisa',
                    'last_name' => 'Doe',
                    'email' => 'lisa@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '44-58777887',
                    'country_id' => 230,
                    'state_id' => 3889,
                    'city_id' => 42382,
                    'provider_id' => NULL,
                    'address' => 'Edinburgh, Scotland, UK',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Lisa Doe',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 12:38:49',
                    'updated_at' => '2023-10-03 13:09:06',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/lisa.png'),
                ],
                [
                    'id' => 48,
                    'username' => 'joy_hanry',
                    'first_name' => 'Joy',
                    'last_name' => 'Hanry',
                    'email' => 'joy@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-55226253',
                    'country_id' => 38,
                    'state_id' => 671,
                    'city_id' => 10269,
                    'provider_id' => NULL,
                    'address' => 'Ontario, Barrie, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Joy Hanry',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 12:42:51',
                    'updated_at' => '2023-10-03 12:37:11',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/joy.png'),
                ],
                [
                    'id' => 49,
                    'username' => 'diana_norris',
                    'first_name' => 'Diana',
                    'last_name' => 'Norris',
                    'email' => 'diana@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-63256255',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => NULL,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Diana Norris',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 12:56:34',
                    'updated_at' => '2023-10-02 13:46:45',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/diana.png'),
                ],
                [
                    'id' => 50,
                    'username' => 'andy_potter',
                    'first_name' => 'Andy',
                    'last_name' => 'Potter',
                    'email' => 'andy@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'user',
                    'contact_number' => '1-44785478',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10839,
                    'provider_id' => NULL,
                    'address' => 'Melville, SK, Canada',
                    'player_id' => '02e37223-24ec-45c3-831b-f550af48c816',
                    'status' => 1,
                    'display_name' => 'Andy Potter',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-05 13:08:57',
                    'updated_at' => '2023-10-03 12:13:42',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/user/andy.png'),
                ],
                [
                    'id' => 51,
                    'username' => 'john_doe',
                    'first_name' => 'John',
                    'last_name' => 'Doe',
                    'email' => 'demo@handyman.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-98574658',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => 4,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => '2890cc77-2f48-4f98-b9e0-f867e488d6b0',
                    'status' => 1,
                    'display_name' => 'John Doe',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-10-06 09:58:28',
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-09 08:07:23',
                    'updated_at' => '2023-10-09 10:35:04',
                    'login_type' => NULL,
                    'service_address_id' => 1,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 1,
                    'designation' => NULL,
                    'last_online_time' => '10:35:04',
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => "I take immense pride in my work as a handyman, and my experience speaks to the love I have for what I do. Each task is an opportunity to showcase my skills and dedication. 😍",
                    'profile_image' => public_path('/images/profile-images/handyman/john.png'),
                ],
                [
                    'id' => 53,
                    'username' => 'antonio_griffin',
                    'first_name' => 'Antonio',
                    'last_name' => 'Griffin',
                    'email' => 'antonio@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-63521452',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10843,
                    'provider_id' => NULL,
                    'address' => 'North Battleford, SK, Canada',
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Antonio Griffin',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-09-25 07:49:34',
                    'updated_at' => '2023-09-25 08:02:08',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/pending/Antonio.png'),
                ],
                [
                    'id' => 54,
                    'username' => 'adam_parry',
                    'first_name' => 'Adam',
                    'last_name' => 'Parry',
                    'email' => 'adam@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-36251842',
                    'country_id' => NULL,
                    'state_id' => NULL,
                    'city_id' => NULL,
                    'provider_id' => NULL,
                    'address' => NULL,
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Adam Parry',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-04 09:38:17',
                    'updated_at' => '2023-10-04 09:38:17',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/pending/adam_parry.png'),
                ],
                [
                    'id' => 55,
                    'username' => 'richard_miller',
                    'first_name' => 'Richard',
                    'last_name' => 'Miller',
                    'email' => 'richardmiller@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '61-52142536',
                    'country_id' => NULL,
                    'state_id' => NULL,
                    'city_id' => NULL,
                    'provider_id' => NULL,
                    'address' => NULL,
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Richard Miller',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-04 09:39:11',
                    'updated_at' => '2023-10-04 09:39:11',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => 2,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/pending/richard_miller.png'),
                ],
                [
                    'id' => 56,
                    'username' => 'tina_francis',
                    'first_name' => 'Tina',
                    'last_name' => 'Francis',
                    'email' => 'tina@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '44-52632235',
                    'country_id' => NULL,
                    'state_id' => NULL,
                    'city_id' => NULL,
                    'provider_id' => NULL,
                    'address' => NULL,
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Tina Francis',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 0,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-04 09:40:02',
                    'updated_at' => '2023-10-04 09:40:02',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => 1,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/pending/tina_francis.png'),
                ],
                [
                    'id' => 57,
                    'username' => 'ralph_stanley',
                    'first_name' => 'Ralph',
                    'last_name' => 'Stanley',
                    'email' => 'ralph@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'handyman',
                    'contact_number' => '1-52552356',
                    'country_id' => NULL,
                    'state_id' => NULL,
                    'city_id' => NULL,
                    'provider_id' => NULL,
                    'address' => NULL,
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Ralph Stanley',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-04 09:40:49',
                    'updated_at' => '2023-10-04 09:40:49',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => 2,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/handyman/pending/ralph_stanley.png'),
                ],
                [
                    'id' => 58,
                    'username' => 'julion_foster',
                    'first_name' => 'Julion',
                    'last_name' => 'Foster',
                    'email' => 'julion@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-75545214',
                    'country_id' => 38,
                    'state_id' => 671,
                    'city_id' => 10269,
                    'provider_id' => NULL,
                    'address' => 'Ontario, Barrie, Canada',
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Julion Foster',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-13 05:41:24',
                    'updated_at' => '2023-10-13 05:47:40',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/pending/Julion.png'),
                ],
                [
                    'id' => 59,
                    'username' => 'cynthia_gross',
                    'first_name' => 'Cynthia',
                    'last_name' => 'Gross',
                    'email' => 'cynthia@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-52235478',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10859,
                    'provider_id' => NULL,
                    'address' => 'Warman, SK, Canada',
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Cynthia Gross',
                    'providertype_id' => 2,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-13 05:44:51',
                    'updated_at' => '2023-10-13 05:48:11',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/pending/Cynthia.png'),
                ],
                [
                    'id' => 60,
                    'username' => 'ruth_fletcher',
                    'first_name' => 'Ruth',
                    'last_name' => 'Fletcher',
                    'email' => 'ruth@gmail.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'provider',
                    'contact_number' => '1-24478563',
                    'country_id' => 231,
                    'state_id' => 3943,
                    'city_id' => 44996,
                    'provider_id' => NULL,
                    'address' => 'New Bedford, MA, USA',
                    'player_id' => NULL,
                    'status' => 0,
                    'display_name' => 'Ruth Fletcher',
                    'providertype_id' => 1,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'is_email_verified' => 1,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2023-10-13 05:50:37',
                    'updated_at' => '2023-10-13 05:51:29',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'why_choose_me' => '{"title":"Why Choose Me","about_description":"With over 10 years of experience in the service industry, I bring professionalism, attention to detail, and a genuine passion for helping clients achieve the best results.","reason":["Quick and reliable service","High customer satisfaction rate","Flexible scheduling to fit your needs"]}',
                    'profile_image' => public_path('/images/profile-images/provider/pending/Ruth.png'),
                ],
            ];
        } else {


            $data = [
                [
                    'id' => 1,
                    'username' => 'admin',
                    'first_name' => 'Super',
                    'last_name' => 'Admin',
                    'email' => 'admin@admin.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'admin',
                    'contact_number' => '9876543210',
                    'country_id' => 38,
                    'state_id' => 674,
                    'city_id' => 10839,
                    'provider_id' => NULL,
                    'address' => 'Melville, SK, Canada',
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Super Admin',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => '2023-09-29 07:47:07',
                    'email_verified_at' => NULL,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2021-05-28 15:59:15',
                    'updated_at' => '2023-10-03 09:52:48',
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/admin/super_admin.png'),
                ],
                [
                    'id' => 2,
                    'username' => 'demo_admin',
                    'first_name' => 'Demo',
                    'last_name' => 'Admin',
                    'email' => 'demo@admin.com',
                    'password' => bcrypt('12345678'),
                    'user_type' => 'demo_admin',
                    'contact_number' => '4564552664',
                    'country_id' => 231,
                    'state_id' => 3924,
                    'city_id' => 42865,
                    'provider_id' => NULL,
                    'address' => NULL,
                    'player_id' => NULL,
                    'status' => 1,
                    'display_name' => 'Demo Admin',
                    'providertype_id' => NULL,
                    'is_featured' => 0,
                    'time_zone' => 'UTC',
                    'last_notification_seen' => NULL,
                    'email_verified_at' => NULL,
                    'remember_token' => NULL,
                    'deleted_at' => NULL,
                    'created_at' => '2021-05-29 05:40:38',
                    'updated_at' => NULL,
                    'login_type' => NULL,
                    'service_address_id' => NULL,
                    'uid' => NULL,
                    'handymantype_id' => NULL,
                    'is_subscribe' => 0,
                    'social_image' => NULL,
                    'is_available' => 0,
                    'designation' => NULL,
                    'last_online_time' => NULL,
                    'slots_for_all_services' => 0,
                    'known_languages' => NULL,
                    'skills' => NULL,
                    'description' => NULL,
                    'profile_image' => public_path('/images/profile-images/admin/demo_admin.png'),
                ],

            ];
        }

        foreach ($data as $key => $val) {
            $featureImage = $val['profile_image'] ?? null;
            $userData = Arr::except($val, ['provider_address', 'profile_image', 'provider_zone']);
            $user = User::create($userData);

            if (isset($val['provider_address'])) {
                $addresses = $val['provider_address'];
                foreach ($addresses as $addressData) {
                    $address = new ProviderAddressMapping($addressData);
                    $address->save();
                }
            }

            if (isset($val['provider_zone'])) {

                $provider_zone = $val['provider_zone'];

                foreach ($provider_zone as $zone) {

                    $zone_data = [
                        'provider_id' => $user->id,
                        'zone_id' => $zone,
                    ];

                    ProviderZoneMapping::create($zone_data);
                }
            }

            $user->assignRole($val['user_type']);
            $user->update();

            if (isset($featureImage)) {
                $this->attachFeatureImage($user, $featureImage);
            }
        }
    }
    private function attachFeatureImage($model, $publicPath)
    {

        $file = new \Illuminate\Http\File($publicPath);

        $media = $model->addMedia($file)->preservingOriginal()->toMediaCollection('profile_image');

        return $media;
    }
}
