import 'package:handyman_provider_flutter/locale/base_language.dart';

class LanguageAr extends Languages {
  @override
  String planAboutToExpire(int days) => 'Your Plan Is About to Expire In $days Days';

  @override
  String get appName => 'مزود';

  @override
  String get provider => 'مزود';

  @override
  String get lblShowingOnly4Handyman => 'اضهار ٤ عمال فقط';

  @override
  String get lblRecentlyOnlineHandyman => 'العمال المتصلون';

  @override
  String get lblStartDrive => 'ابدأ القيادة';

  @override
  String get handyman => 'عامل';

  @override
  String get signIn => 'تسجيل دخول';

  @override
  String get signUp => 'اشتراك';

  @override
  String get hintFirstNameTxt => 'أدخل اسمك الأول';

  @override
  String get hintLastNameTxt => 'أدخل اسم العائلة';

  @override
  String get hintContactNumberTxt => 'أدخل رقم الاتصال الخاص بك';

  @override
  String get hintEmailAddressTxt => 'أدخل عنوان بريدك الالكتروني';

  @override
  String get hintUserNameTxt => 'أدخل اسم المستخدم الخاص بك';

  @override
  String get hintReenterPasswordTxt => 'إعادة إدخال كلمة المرور';

  @override
  String get confirm => 'تاكيد';

  @override
  String get forgotPassword => 'هل نسيت كلمة السر؟';

  @override
  String get alreadyHaveAccountTxt => 'هل لديك حساب';

  @override
  String get rememberMe => 'تذكرنى';

  @override
  String get forgotPasswordTitleTxt => 'أدخل عنوان بريدك الالكتروني';

  @override
  String get resetPassword => 'إعادة تعيين كلمة المرور';

  @override
  String get editProfile => 'تعديل الملف الشخصي';

  @override
  String get saveChanges => 'حفظ التغييرات';

  @override
  String get camera => 'الكميرا';

  @override
  String get language => 'اللغات';

  @override
  String get appTheme => 'سمة التطبيق';

  @override
  String get bookingHistory => 'تاريخ الحجز';

  @override
  String get logout => 'تسجيل خروج';

  @override
  String get afterLogoutTxt => 'هل ترغب في تسجيل الخروج من التطبيق؟ يمكنك دائما تسجيل الدخول مرة أخرى!';

  @override
  String get chooseTheme => 'اختر سمة التطبيق';

  @override
  String get selectCountry => 'حدد الدولة';

  @override
  String get selectState => 'اختر مدينة';

  @override
  String get selectCity => 'اختر مدينة';

  @override
  String get changePassword => 'تغيير كلمة المرور';

  @override
  String get passwordNotMatch => 'كلمة السر غير متطابقة';

  @override
  String get doNotHaveAccount => 'ليس لديك حساب؟';

  @override
  String get hintNewPasswordTxt => 'كلمة المرور الجديدة';

  @override
  String get hintOldPasswordTxt => 'كلمة المرور القديمة';

  @override
  String get review => 'تقييم';

  @override
  String get notification => 'إشعارات';

  @override
  String get accept => 'قبول';

  @override
  String get decline => 'رفض';

  @override
  String get noDataFound => 'لاتوجد بيانات';

  @override
  String get pending => 'قيد الانتظار';

  @override
  String get darkMode => 'الوضع المظلم';

  @override
  String get lightMode => 'وضع ضوء';

  @override
  String get systemDefault => 'وضع النظام';

  @override
  String get confirmationRequestTxt => 'هل أنت متأكد من أن تنفيذ هذا الإجراء؟';

  @override
  String get notAvailable => 'غير متوفر';

  @override
  String get lblGallery => 'الصور';

  @override
  String get cantLogin => 'لا يمكن تسجيل الدخول';

  @override
  String get pleaseContactAdmin => 'يرجى الاتصال مع المسؤول';

  @override
  String get lblOk => 'نعم';

  @override
  String get paymentStatus => 'حالة السداد';

  @override
  String get paymentMethod => 'طريقة الدفع او السداد';

  @override
  String get hintAddress => 'أدخل العنوان';

  @override
  String get quantity => 'كمية';

  @override
  String get lblYes => 'نعم';

  @override
  String get lblNo => 'لا';

  @override
  String get lblReason => 'السبب';

  @override
  String get lblSelectHandyman => 'يرجى اختيار Handyman.';

  @override
  String get lblAssign => 'تعيين';

  @override
  String get lblCall => 'اتصال';

  @override
  String get lblAssignHandyman => 'تعيين Handyman.';

  @override
  String get lblAssigned => 'مكلف';

  @override
  String get viewAll => 'عرض الكل';

  @override
  String get lblMonthlyRevenue => 'الإيرادات الشهرية';

  @override
  String get lblRevenue => 'إيرادات';

  @override
  String get lblAddHandyman => 'أضف Handyman.';

  @override
  String get lblBooking => 'الحجز';

  @override
  String get lblTotalBooking => 'مجموع حجوزات';

  @override
  String get lblTotalService => 'إجمالي الخدمات';

  @override
  String get lblTotalHandyman => 'مجموع العمال';

  @override
  String get monthlyEarnings => 'الدخل الشهري';

  @override
  String get lblPayment => 'الدفعات';

  @override
  String get lblBookingID => 'رقم الحجز';

  @override
  String get lblPaymentID => 'معرف الدفع';

  @override
  String get lblAmount => 'كمية';

  @override
  String get hintAddService => 'إضافة خدمة';

  @override
  String get hintServiceName => 'أدخل اسم الخدمة';

  @override
  String get hintSelectCategory => 'اختر الفئة';

  @override
  String get hintSelectType => 'اختر نوع الخدمة';

  @override
  String get hintSelectStatus => 'حدد الحالة';

  @override
  String get hintPrice => 'سعر';

  @override
  String get hintDiscount => 'خصم';

  @override
  String get hintDuration => 'مدة';

  @override
  String get hintDescription => 'وصف';

  @override
  String get hintSetAsFeature => 'تعيين كخدمة مميزة';

  @override
  String get hintAdd => 'اضافة';

  @override
  String get hintChooseImage => 'اختر صورة';

  @override
  String get customer => 'عميل';

  @override
  String get lblProfile => 'الملف الشخصي';

  @override
  String get lblAllHandyman => 'كل العمال';

  @override
  String get lblTime => 'الوقت';

  @override
  String get lblMyService => 'خدماتي';

  @override
  String get lblAllService => 'كل الخدمات';

  @override
  String get lblChat => 'دردشة';

  @override
  String get selectAddress => 'حدد عناوين الخدمة';

  @override
  String get btnSave => 'حفظ';

  @override
  String get editAddress => 'تحرير عنوان الخدمة';

  @override
  String get lblUpdate => 'تحديث';

  @override
  String get lblEdit => 'تحرير';

  @override
  String get lblDelete => 'حذف';

  @override
  String get lblServiceAddress => 'عناوين الخدمة';

  @override
  String get lblServices => 'خدمات';

  @override
  String get lblEditService => 'تحرير الخدمة';

  @override
  String get selectImgNote => "ملاحظة: يمكنك تحميل الصور من نوع \ 'jpg \'، \ 'png \'، \ 'jpeg \' extensions & يمكنك تحديد صور متعددة";

  @override
  String get lblDurationHr => 'المدة: ساعات';

  @override
  String get lblDurationMin => 'المدة: دقيقة';

  @override
  String get lblWaitForAcceptReq => 'يرجى انتظار الادارة لقبول طلبك';

  @override
  String get lblAddServiceAddress => 'إضافة عنوان للخدمة';

  @override
  String get errorPasswordLength => 'يجب أن يكون طول كلمة المرور أكثر من';

  @override
  String get hintPassword => 'كلمه السر';

  @override
  String get hintRequired => 'هذه الخانة مطلوبه';

  @override
  String get lblUnAuthorized => "لا يمكن منح المستخدم التجريبي لهذا الإجراء";

  @override
  String get btnVerifyId => "تحقق من هويتك";

  @override
  String get confirmationUpload => 'هل أنت متأكد من تحميل هذا المستند؟';

  @override
  String get toastSuccess => "تم حفظ وثيقة المزود بنجاح";

  @override
  String get lblSelectDoc => "حدد المستند";

  @override
  String get lblAddDoc => "إضافة المستندات";

  @override
  String get lblRateUs => "قيمنا";

  @override
  String get lblTermsAndConditions => 'الشروط والأحكام';

  @override
  String get lblPrivacyPolicy => "سياسة الخصوصية";

  @override
  String get lblHelpAndSupport => 'المساعدة والدعم';

  @override
  String get lblAbout => "عن";

  @override
  String get lblProviderType => "نوع مقدم الخدمة";

  @override
  String get lblMyCommission => "عمولتي";

  @override
  String get lblTaxes => "الضرائب";

  @override
  String get lblTaxName => "نوع الضريبة";

  @override
  String get lblMyTax => "الضرائب الخاصة بي";

  @override
  String get lblLoginTitle => "مرحبا مجددا !";

  @override
  String get lblLoginSubtitle => "مرحبا بك مرة أخرى";

  @override
  String get lblSignupTitle => "مرحبا";

  @override
  String get lblSignupSubtitle => "انشيء حسابك للحصول على تجربة أفضل";

  @override
  String get lblSignup => "تسجيل";

  @override
  String get lblUserType => "نوع المستخدم";

  @override
  String get lblPurchaseCode => "شراء شفرة المصدر الكامل";

  @override
  String get lblRating => "تقييم";

  @override
  String get lblOff => "خصم";

  @override
  String get lblHr => "ساعة";

  @override
  String get lblDate => "تاريخ";

  @override
  String get lblAboutHandyman => "عن العمال";

  @override
  String get lblAboutCustomer => "عن العميل";

  @override
  String get lblPaymentDetail => "تفاصيل الدفع";

  @override
  String get lblId => "هوية شخصية";

  @override
  String get lblMethod => "طريقة";

  @override
  String get lblStatus => "حالة الخدمة";

  @override
  String get lblPriceDetail => "تفاصيل السعر";

  @override
  String get lblSubTotal => "المجموع الفرعي";

  @override
  String get lblTax => "ضريبة";

  @override
  String get lblCoupon => "كوبون";

  @override
  String get lblTotalAmount => "المبلغ الإجمالي";

  @override
  String get lblOnBasisOf => "على أساس";

  @override
  String get lblCheckStatus => "تحقق من حالةالخدمة";

  @override
  String get lblCancel => "الغاء";

  @override
  String get lblUnreadNotification => "غير مقروء";

  @override
  String get lblMarkAllAsRead => "اشر عليها بانها قرات";

  @override
  String get lblCloseAppMsg => "اضغط مرة أخرى مرة أخرى للخروج من التطبيق";

  @override
  String get lblAddress => "عنوان";

  @override
  String get lblType => "النوع";

  @override
  String get lblHandymanType => "Handyman نوع";

  @override
  String get lblFixed => "سعر ثابت";

  @override
  String get lblHello => "أهلا";

  @override
  String get lblWelcomeBack => "مرحبا بعودتك!";

  @override
  String get lblNoReviewYet => "لا يوجد تقييمات";

  @override
  String get lblWaitingForResponse => "بإنتظار الرد";

  @override
  String get lblConfirmPayment => "تأكيد الدفع";

  @override
  String get lblDelivered => "تم الوصول";

  @override
  String get lblDay => "يوم";

  @override
  String get lblYear => "سنة";

  @override
  String get lblExperience => "الخبرة";

  @override
  String get lblOf => "(ق) من";

  @override
  String get lblSelectAddress => "اختر العنوان";

  @override
  String get lblOppS => "Opps";

  @override
  String get lblNoInternet => "الرجاء التاكد من اتصالك بالانترنت، يرجى المحاولة مرة أخرى.";

  @override
  String get lblRetry => "اعادة";

  @override
  String get lblServiceStatus => "حالة الخدمة";

  @override
  String get lblMemberSince => "عضو منذ";

  @override
  String get lblDeleteAddress => "حذف العنوان";

  @override
  String get lblDeleteAddressMsg => 'هل تريد حذف هذا العنوان؟';

  @override
  String get lblChoosePaymentMethod => "اختر وسيلة الدفع";

  @override
  String get lblNoPayments => "لا مدفوعات";

  @override
  String get lblPayWith => "هل تريد أن تدفع مع";

  @override
  String get lblProceed => "تقدم";

  @override
  String get lblPricingPlan => "خطة التسعير";

  @override
  String get lblSelectPlan => 'على استعداد للبدء؟';

  @override
  String get lblMakePayment => "قم بالدفع";

  @override
  String get lblRestore => "يعيد";

  @override
  String get lblForceDelete => "حذف";

  @override
  String get lblActivated => "فعال";

  @override
  String get lblDeactivated => "إلغاء تفعيل";

  @override
  String get lblNoDescriptionAvailable => "لا يوجد وصف متاح";

  @override
  String get lblFAQs => "أسئلة وأجوبة";

  @override
  String get lblGetDirection => "احصل على اتجاه";

  @override
  String get lblDeleteTitle => "سيتم حذف الحساب";

  @override
  String get lblDeleteSubTitle => "هل ترغب بالخروج؟";

  @override
  String get lblUpcomingServices => "الخدمات القادمة";

  @override
  String get lblTodayServices => "خدمات اليوم";

  @override
  String get lblPlanExpired => "opps! انتهاء صلاحية الاشتراك";

  @override
  String get lblPlanSubTitle => "انتهت صلاحية اشتراكك السابق";

  @override
  String get btnTxtBuyNow => "اشتري الآن";

  @override
  String get lblChooseYourPlan => "اختر خطتك";

  @override
  String get lblRenewSubTitle => "شراء خطة جديدة للحصول على حجوزات خدمة جديدة";

  @override
  String get lblReminder => "تذكير";

  @override
  String get lblRenew => "تجديد";

  @override
  String get lblCurrentPlan => "الخطة الحالية";

  @override
  String get lblValidTill => "صالح لغاية";

  @override
  String get lblSearchHere => "ابحث هنا...";

  @override
  String get lblEarningList => "قائمة الارباح";

  @override
  String get lblSubscriptionTitle => 'هل تريد إلغاء الخطة الحالية؟';

  @override
  String get lblPlan => "حزمة";

  @override
  String get lblCancelPlan => "إلغاء الحزمة";

  @override
  String get lblSubscriptionHistory => "تاريخ الاشتراك";

  @override
  String get lblTrashHandyman => "كان Handyman القمامة بنجاح";

  @override
  String get lblPlsSelectAddress => "يرجى تحديد العنوان";

  @override
  String get lblPlsSelectCategory => "الرجاء اختيار الفئة";

  @override
  String get lblEnterHours => "أدخل ساعات تصل إلى 24 ساعة";

  @override
  String get lblEnterMinute => "أدخل الدقيقة حتى 60 دقيقة";

  @override
  String get lblSelectSubCategory => "حدد الفئة الفرعية";

  @override
  String get lblServiceProof => "دليل الخدمة";

  @override
  String get lblTitle => "عنوان";

  @override
  String get lblAddImage => "إضافة صورة";

  @override
  String get lblSubmit => "إرسال";

  @override
  String get lblWalletHistory => "تاريخ المحفظة";

  @override
  String get lblServiceRatings => "تقييمات الخدمة";

  @override
  String get lblWallet => "محفظة";

  @override
  String get lblSelectCommission => 'حدد العمولة';

  @override
  String get lblIAgree => "محفظة";

  @override
  String get lblTermsOfService => "حدد نوع المستخدم";

  @override
  String get lblLoginAgain => "أنا أوافق على";

  @override
  String get lblTermCondition => "شروط الخدمة";

  @override
  String get lblServiceTotalTime => "إجمالي الخدمة";

  @override
  String get lblHelpLineNum => "رقم خط المساعدة";

  @override
  String get lblReasonCancelling => "سبب إلغاء هذا الحجز";

  @override
  String get lblReasonRejecting => "سبب رفض هذا الحجز";

  @override
  String get lblFailed => "سبب فشل هذا الحجز";

  @override
  String get lblDesignation => "اللقب";

  @override
  String get lblHandymanIsOffline => "العامل غير متصل";

  @override
  String get lblDoYouWantToRestore => "هل تريد استعادة؟";

  @override
  String get lblDoYouWantToDeleteForcefully => "هل تريد الحذف ؟";

  @override
  String get lblDoYouWantToDelete => "هل تريد أن تحذف؟";

  @override
  String get lblPleaseEnterMobileNumber => "الرجاء إدخال رقم الهاتف المحمول";

  @override
  String get lblDangerZone => "الغاء الحساب بشكل كامل";

  @override
  String get lblDeleteAccount => "حذف الحساب";

  @override
  String get lblDeleteAccountConformation => "سيتم حذف حسابك بشكل دائم. لن تتم استعادة بياناتك مرة أخرى.";

  @override
  String get lblUnderMaintenance => "تحت الصيانة...";

  @override
  String get lblCatchUpAfterAWhile => "التحصيل بعد فترة من الوقت";

  @override
  String get lblRecheck => "إعادة فحص";

  @override
  String get lblTrialFor => "مجانا";

  @override
  String get lblDays => "أيام";

  @override
  String get lblFreeTrial => "تجربة مجانية";

  @override
  String get lblAtLeastOneImage => " صوراخترة واحدة على at-east";

  @override
  String get lblService => "خدمة";

  @override
  String get lblNewUpdate => "تحديث جديد";

  @override
  String get lblOptionalUpdateNotify => "تحديث اختياري ";

  @override
  String get lblAnUpdateTo => "تحديث ل";

  @override
  String get lblIsAvailableWouldYouLike => "متاح. هل ترغب في تحديث؟";

  @override
  String lblAreYouSureYouWantToAssignThisServiceTo(String name) => "Do you want to assign this service to $name?";

  @override
  String get lblAreYouSureYouWantToAssignToYourself => 'هل تريد أن تسند لنفسك؟';

  @override
  String get lblAssignToMyself => "تعيين لنفسي";

  @override
  String get lblFree => "غير مدفوع الأجر";

  @override
  String get lblMyProvider => "مزود خدمة";

  @override
  String get lblAvailableStatus => "الحالة المتاحة";

  @override
  String get lblYouAre => "أنت";

  @override
  String get lblEmailIsVerified => "تم التحقق من البريد الإلكتروني";

  @override
  String get lblHelp => "مساعدة";

  @override
  String get lblAddYourCountryCode => "أضف رمز بلدك";

  @override
  String get lblRegistered => "مسجل";

  @override
  String get lblRequiredAfterCountryCode => "مطلوب بعد رمز البلد";

  @override
  String get lblExtraCharges => "رسوم إضافية";

  @override
  String get lblAddExtraCharges => "أضف رسوم إضافية";

  @override
  String get lblCompleted => 'اكتمل';

  @override
  String get lblAddExtraChargesDetail => "إضافة تفاصيل الرسوم الاضافية";

  @override
  String get lblEnterExtraChargesDetail => "أدخل تفاصيل الرسوم الاضافية";

  @override
  String get lblTotalCharges => "الكلفة الاجماليه";

  @override
  String get lblSuccessFullyAddExtraCharges => "تم إضافة الرسوم الاضافية  بنجاح";

  @override
  String get lblChargeName => "اسم المسؤول";

  @override
  String get lblPrice => "سعر";

  @override
  String get lblEnterAmount => "أدخل المبلغ";

  @override
  String get lblHourly => "بالساعة";

  @override
  String get noBookingTitle => "لم يتم العثور على الحجز";

  @override
  String get noBookingSubTitle => "يبدو أن عميلك لم يحجز خدماتك بعد";

  @override
  String get noNotificationTitle => "لا يوجد اسم للاشعار";

  @override
  String get noNotificationSubTitle => "سنقوم بإعلامك بمجرد أن يكون لدينا شيء لك";

  @override
  String get noHandymanAvailable => "العمال غير متصلون";

  @override
  String get noHandymanYet => "لا يوجد عمال لغاية الان";

  @override
  String get noHandymanSubTitle => "لا يوجد عمال لغاية الان";

  @override
  String get noServiceFound => "لم يتم العثور على خدمة";

  @override
  String get noServiceSubTitle => "لم يتم العثور على خدمة";

  @override
  String get noServiceAddressTitle => "لم يتم العثور على عنوان الخدمة";

  @override
  String get noServiceAddressSubTitle => "أضف عنوان الخدمة الخاص بك أولاً ثم يظهر هنا";

  @override
  String get noSubscriptionPlan => "لا توجد خطة اشتراك هنا";

  @override
  String get noSubscriptionFound => "لم يتم العثور على اشتراك";

  @override
  String get noSubscriptionSubTitle => "لم تشترك في أي خطة";

  @override
  String get noTexesFound => "";

  @override
  String get noWalletHistoryTitle => "لم يتم العثور على سجلات في المحفظة";

  @override
  String get noWalletHistorySubTitle => "لم يتم العثور على سجلات في المحفظة";

  @override
  String get noExtraChargesHere => "لا توجد رسوم إضافية هنا";

  @override
  String get getYourFirstReview => "احصل على المراجعة الأولى";

  @override
  String get ratingViewAllSubtitle => "شاهد التقييمات العالية لخذماتك";

  @override
  String get noDocumentFound => "لم يتم العثور على وثيقة";

  @override
  String get noDocumentSubTitle => "لا يوجد وثيقة للتحقق";

  @override
  String get noConversation => "لا محادثة";

  @override
  String get jobRequestList => 'قائمة طلبات الخدمات';

  @override
  String get bidList => 'قائمة العطاءات';

  @override
  String get bid => 'مُنَاقَصَة';

  @override
  String get postJobTitle => 'طلب خدمة خاصة';

  @override
  String get postJobDescription => ' تفاصيل الخذمة الخاصة';

  @override
  String get jobPrice => 'سعر الخدمة';

  @override
  String get estimatedPrice => 'السعر المقدر';

  @override
  String get assignedProvider => 'مزود مخصص';

  @override
  String get giveYourEstimatePriceHere => 'ادخل تقدير سعر الخاص بك هنا';

  @override
  String get pleaseEnterValidBidPrice => 'الرجاء إدخال سعر العرض الصحيح';

  @override
  String get yourPriceShouldNotBeLessThan => 'يجب ألا يكون سعرك أقل من';

  @override
  String get enterBidPrice => 'أدخل سعر العرض';

  @override
  String get myBid => 'عطائاتي';

  @override
  String get inputMustBeNumberOrDigit => 'يجب أن يكون الإدخال ارفام';

  @override
  String get requiredAfterCountryCode => 'مطلوب بعد رمز البلد';

  @override
  String get internetNotAvailable => 'الرجاء التاكد من اتصالك بالانترنت';

  @override
  String get pleaseTryAgain => 'حاول مرة اخرى';

  @override
  String get somethingWentWrong => 'حصل خطأ';

  @override
  String get thisSlotIsNotAvailable => 'هذا الوقت غير متاح';

  @override
  String get notes => 'ملاحظات:';

  @override
  String get timeSlotsNotes1 => 'تحديد الوقت هو فقط لمقدمي الخدمات.';

  @override
  String get timeSlotsNotes2 => 'يمكنك ضبط اوقات العمل لكل خدمة.';

  @override
  String get timeSlotsNotes3 => 'سيتمكن العميل من رؤية اوقات العمل فقط عند تفعيلها في خدمة معينة.';

  @override
  String get noSlotsAvailable => 'لا يوجد اوقات عمل متاحة';

  @override
  String get timeSlots => 'اوقات العمل';

  @override
  String get selectYourDay => 'حدد اليوم';

  @override
  String get chooseTime => 'اختر الوقت';

  @override
  String get copyTo => 'نسخ الى';

  @override
  String get pleaseWaitWhileWeChangeTheStatus => 'الرجاء الانتظار أثناء تغيير الحالة';

  @override
  String get myTimeSlots => 'اوقات عملي';

  @override
  String get day => 'يوم';

  @override
  String get pleaseSelectServiceAddresses => 'الرجاء تحديد مواقع تقديم الخدمة';

  @override
  String get pleaseSelectImages => 'الرجاء تحديد الصور';

  @override
  String get timeSlotAvailable => 'اوقات العمل المتاحة';

  @override
  String get doesThisServicesContainsTimeslot => 'هل تحتوي هذه الخدمات على فترات زمنية';

  @override
  String get pleaseEnterTheDefaultTimeslotsFirst => 'الرجاء إدخال الأوقات الافتراضية أولاً';

  @override
  String get chooseAction => 'اختر الإجراء';

  @override
  String get chooseImage => 'اختر صورة';

  @override
  String get removeImage => 'إزالة الصورة';

  @override
  String get availableAt => 'متاحة في';

  @override
  String get clearChat => 'حذف الدردشة';

  @override
  String get upcomingBookings => 'الحجوزات القادمة';

  @override
  String get postJob => 'طلب عمل';

  @override
  String get categoryBasedPackage => 'فئات الحزمة';

  @override
  String get subTitleOfSelectService => 'عند تمكين هذه الميزة ، ستتمكن من اختيار الخدمة من فئات متعددة.';

  @override
  String get enabled => 'فعال';

  @override
  String get disabled => 'غير فعال ';

  @override
  String get doYouWantTo => 'هل انت ترغب في';

  @override
  String get enable => 'تفعيل';

  @override
  String get disable => 'الغاء تفعيل';

  @override
  String get package => 'حزمة';

  @override
  String get packages => 'حزم';

  @override
  String get packageService => 'خدمة الحزمة';

  @override
  String get confirmationRemovePackage => 'هل تريد إزالة هذه الخدمة من الحزمة؟';

  @override
  String get packageName => 'اسم الحزمة';

  @override
  String get selectService => 'حدد الخدمة';

  @override
  String get packageDescription => 'وصف الحزمة';

  @override
  String get packagePrice => 'سعر الحزمة';

  @override
  String get startDate => 'تاريخ البدء';

  @override
  String get endDate => 'تاريخ الانتهاء';

  @override
  String get pleaseSelectService => 'الرجاء تحديد الخدمة';

  @override
  String get pleaseEnterTheEndDate => 'الرجاء إدخال تاريخ الانتهاء';

  @override
  String get editPackage => 'تحرير الحزمة';

  @override
  String get addPackage => 'أضف الحزمة';

  @override
  String get areYouSureWantToDeleteThe => 'هل أنت متأكد من حذف';

  @override
  String get packageNotAvailable => 'الحزمة غير متوفرة';

  @override
  String get includedInThisPackage => 'مضافة في هذه الحزمة';

  @override
  String get packageServicesWillAppearHere => 'ستظهر خدمات الحزمة هنا';

  @override
  String get showingFixPriceServices => 'إظهار الخدمات ثابتة الاسعار';

  @override
  String get pleaseSelectTheCategory => 'الرجاء تحديد الفئة';

  @override
  String get lblInvalidTransaction => 'المعاملة غير صالحة';

  @override
  String get youWillGetTheseServicesWithThisPackage => 'ستحصل على هذه الخدمات مع هذه الحزمة';

  @override
  String get lblSearchFullAddress => 'ابحث باستخدام العنوان الكامل';

  @override
  String get lblPleaseSelectCity => 'الرجاء تحديد المدينة';

  @override
  String get lblChooseOneImage => "ختر صورة واحدة";

  @override
  String get lblNoTransactionFound => 'لم يتم العثور على معاملة';

  @override
  String get lblSubTitleNoTransaction => 'لم يتم العثور على شيء في السجل حتى الآن. إكمال الخدمات أولاً ثم احصل على الدفع';

  @override
  String get lblCheckOutWithCinetPay => 'الخروج مع CinetPay';

  @override
  String get yourPaymentFailedPleaseTryAgain => 'فشلت دفعتك ، يرجى المحاولة مرة أخرى';

  @override
  String get yourPaymentHasBeenMadeSuccessfully => 'تم سداد دفعتك بنجاح';

  @override
  String get lblTransactionFailed => 'فشل الاجراء';

  @override
  String get lblTransactionCancelled => 'تم إلغاء المعاملة';

  @override
  String get lblStripeTestCredential => 'لا يمكن اختبار بيانات الاعتماد أكثر من 500';

  @override
  String get lblSuccessFullyActivated => 'تم تنشيطه بنجاح';

  @override
  String get lblNoTaxesFound => 'لم يتم العثور على ضرائب';

  @override
  String get lblConfirmationForDeleteMsg => 'هل تريد حذف الرسالة؟';

  @override
  String get lblImage => 'صورة';

  @override
  String get lblVideo => 'فيديو';

  @override
  String get lblAudio => 'صوتي';

  @override
  String get lblMessage => 'رسالة';

  @override
  String get chatCleared => 'تم مسح الدردشة';

  @override
  String get lblNoEarningFound => 'لم يتم العثور على ايرادات';

  @override
  String get lblNoUserFound => 'لم يتم العثور على المستخدم';

  @override
  String get lblTokenExpired => 'انتهت صلاحية الرمز';

  @override
  String get lblFailedToLoadPredictions => 'فشل تحميل التنبؤات';

  @override
  String get personalInfo => 'معلومات شخصية';

  @override
  String get essentialSkills => 'مهارات اساسيه';

  @override
  String get knownLanguages => 'اللغات المعروفة';

  @override
  String get addEssentialSkill => 'أضف مهارة أساسية';

  @override
  String get addKnownLanguage => 'أضف لغة معروفة';

  @override
  String get authorBy => 'مؤلف';

  @override
  String get views => 'الآراء';

  @override
  String get deleteBlogTitle => 'هل تريد حذف هذه المدونة؟';

  @override
  String get enterBlogTitle => 'أدخل عنوان مدونتك';

  @override
  String get updateBlog => 'تحديث المدونة';

  @override
  String get addBlog => 'أضف مدونة';

  @override
  String get blogs => 'المدونات';

  @override
  String get noBlogsFound => 'لم يتم العثور على مدونات';

  @override
  String get aboutYou => 'حولك';

  @override
  String get pleaseAddKnownLanguage => 'الرجاء إضافة لغة معروفة';

  @override
  String get pleaseAddEssentialSkill => 'الرجاء إضافة مهارة أساسية';

  @override
  String get published => 'تم النشر';

  @override
  String get clearChatMessage => 'هل تريد مسح هذه الدردشة؟';

  @override
  String get all => 'الجميع';

  @override
  String get accepted => 'تم القبول';

  @override
  String get onGoing => 'جاري التنفيذ';

  @override
  String get inProgress => 'قيد العمل الان';

  @override
  String get hold => 'توقف';

  @override
  String get cancelled => 'ألغيت';

  @override
  String get rejected => 'مرفوض';

  @override
  String get failed => 'فشل';

  @override
  String get completed => 'مكتمل';

  @override
  String get pendingApproval => 'ما زال يحتاج الى الموافقة';

  @override
  String get waiting => 'في انتظار الرد';

  @override
  String get paid => 'مدفوع';

  @override
  String get advancePaid => 'دفع مسبق';

  @override
  String get advancePayAmountPer => 'مبلغ الدفع المسبق (٪)';

  @override
  String get enablePrePayment => 'تفعيل الدفع المسبق';

  @override
  String get enablePrePaymentMessage => 'هذا يتيح دفع الخدمة مقدمًا';

  @override
  String get invalidInput => 'ادخال غير صحيح';

  @override
  String get remainingAmount => 'الكمية المتبقية';

  @override
  String get advancePayment => 'الدفع المسبق';

  @override
  String get valueConditionMessage => 'يجب أن تكون القيمة من 0 إلى 99';

  @override
  String get withExtraAndAdvanceCharge => 'مع رسوم إضافية ودفع مسبق';

  @override
  String get withExtraCharge => 'تكلفة اضافية';

  @override
  String get min => 'دقيقة';

  @override
  String get hour => 'ساعة';

  @override
  String get lblChangeCountry => "تغيير الدولة";

  @override
  String get lblExample => "مثال";

  @override
  String get active => 'نشط';

  @override
  String get inactive => 'غير نشط';

  @override
  String get use24HourFormat => 'استخدام تنسيق 24 ساعة؟';

  @override
  String get successfullyActivated => 'تم تنشيطه بنجاح';

  @override
  String get providerHome => 'مزود المنزل';

  @override
  String get handymanHome => 'عامل المنزل';

  @override
  String get home => 'منزل';

  @override
  String get selectPlanSubTitle => 'اختر خطة مصممة لاحتياجاتك';

  @override
  String get userRole => 'دور المستخدم';

  @override
  String get paymentHistory => 'سجل الدفعات';

  @override
  String get theService => 'الخدمة';

  @override
  String get selectDuration => 'حدد المدة';

  @override
  String get thisServiceMayTake => 'قد تستغرق هذه الخدمة';

  @override
  String get priceAmountValidationMessage => 'يجب أن يكون مبلغ السعر اكثر من 0';

  @override
  String get lblFeatureBlog => 'هذه مدونة مميزة';

  @override
  String get changePasswordTitle => 'يجب أن تكون كلمة المرور الجديدة مختلفة عن كلمة المرور السابقة المستعملة';

  @override
  String get forgotPasswordSubtitle => 'سيتم إرسال رابط كلمة مرور إعادة تعيين إلى عنوان البريد الإلكتروني الذي تم إدخاله أعلاه';

  @override
  String get badRequest => '400 خطا';

  @override
  String get forbidden => '403 خطا';

  @override
  String get pageNotFound => '404: الصفحة لم يتم العثور عليها';

  @override
  String get tooManyRequests => '429: الكثير من الطلبات';

  @override
  String get internalServerError => '500: خطأ الخادم الداخلي';

  @override
  String get badGateway => '502 مدخل غير صالح';

  @override
  String get serviceUnavailable => '503 الخدمة غير متوفرة';

  @override
  String get gatewayTimeout => '504 البوابة انتهى الزمن';

  @override
  String get requested => 'تم الطلب';

  @override
  String get assigned => 'مُكَلَّف';

  @override
  String get reload => 'إعادة تحميل';

  @override
  String get noConversationSubTitle => 'لم تجري أي محادثة بعد';

  @override
  String get noServiceAccordingToCoordinates => 'لا يمكن العثور على أي نتيجة للعنوان أو الإحداثيات المقدمة';

  @override
  String get isNotValid => 'غير صحيح';

  @override
  String get unlimited => 'غير محدود';

  @override
  String get upTo => 'يصل إلى';

  @override
  String get amountToBeReceived => 'المبلغ الواجب استلامه';

  @override
  String get yourCashPaymentForBookingId => 'دفعك النقدي لحجز معرف';

  @override
  String get isAcceptedAsOn => 'مقبول كما في';

  @override
  String get sendCashToProvider => 'أرسل النقود إلى المزود';

  @override
  String get sendCashToAdmin => 'أرسل النقود إلى المسؤول';

  @override
  String get cashPaymentApproval => 'موافقة الدفع النقدي';

  @override
  String get approvedByHandyman => 'وافق عليها هانيدان';

  @override
  String get sentToProvider => 'أرسل إلى مزود';

  @override
  String get pendingByProvider => 'معلق من قبل المزود';

  @override
  String get approvedByProvider => 'معتمد من قبل المزود';

  @override
  String get pendingByAdmin => 'معلق من قبل المسؤول';

  @override
  String get approvedByAdmin => 'معتمد من قبل المسؤول';

  @override
  String get sentToAdmin => 'أرسل إلى المسؤول';

  @override
  String get ofTransfer => 'من النقل';

  @override
  String get refNumber => 'المرجع. رقم';

  @override
  String get todaySEarning => 'كسب اليوم';

  @override
  String get cash => 'نقدي';

  @override
  String get bank => 'بنك';

  @override
  String get handymanApprovedTheRequest => 'وافق هاندمان على الطلب';

  @override
  String get requestSentToTheProvider => 'طلب تم إرساله إلى المزود';

  @override
  String get requestSentToTheAdmin => 'طلب إرسال إلى المسؤول';

  @override
  String get requestPendingWithTheProvider => 'طلب معلق مع المزود';

  @override
  String get providerApprovedTheRequest => 'وافق المزود على الطلب';

  @override
  String get requestPendingWithTheAdmin => 'طلب معلق مع المسؤول';

  @override
  String get adminApprovedTheRequest => 'وافق المسؤول على الطلب';

  @override
  String get today => 'اليوم';

  @override
  String get yesterday => 'أمس';

  @override
  String get customDate => 'موعد مخصص';

  @override
  String get totalCash => 'إجمالي النقد في متناول اليد';

  @override
  String get tomorrow => 'غداً';

  @override
  String get cashList => 'قائمة نقدية';

  @override
  String get sortBy => 'ترتيب حسب';

  @override
  String get noPaymentsFounds => 'لا توجد مدفوعات أسس';

  @override
  String get cashBalance => 'الرصيد النقدي';

  @override
  String get close => 'يغلق';

  @override
  String get retryPaymentDetails => 'أعد إعادة تقديم تفاصيل الدفع';

  @override
  String get totalAmountToPay => 'إجمالي المبلغ للدفع';

  @override
  String get from => 'من';

  @override
  String get booking => 'الحجز';

  @override
  String get choosePaymentMethod => 'اختر وسيلة الدفع';

  @override
  String get sendToAdmin => 'أرسل إلى المسؤول';

  @override
  String get sendToProvider => 'أرسل إلى مزود';

  @override
  String get detailsOfTheBank => 'تفاصيل البنك';

  @override
  String get selectABankTransferMoneyAndEnterTheReferenceIDInTheTextFieldBelow => 'حدد بنكًا ، وتحويل الأموال ، وأدخل المعرف المرجعي في حقل النص أدناه.';

  @override
  String get noBanksAvailable => 'لا البنوك المتاحة';

  @override
  String get chooseCashOrContactAdminForBankInformation => 'اختر النقود أو الاتصال المسؤول للحصول على معلومات مصرفية';

  @override
  String get bankName => 'اسم البنك';

  @override
  String get accountNumber => 'رقم حساب';

  @override
  String get iFSCCode => 'رمز IFSC';

  @override
  String get bankAddress => 'عنوان البنك';

  @override
  String get pleaseWaitWhileWeLoadBankDetails => 'الرجاء الانتظار أثناء تحميل تفاصيل البنوك ...';

  @override
  String get cashPaymentConfirmation => 'تأكيد الدفع النقدي';

  @override
  String get remark => 'ملاحظة';

  @override
  String get pleaseWaitWhileWeLoadChatDetails => 'يرجى الانتظار أثناء تحميل تفاصيل الدردشة';

  @override
  String get isNotAvailableForChat => 'غير متوفر للدردشة';

  @override
  String get connectWithFirebaseForChat => 'تواصل مع Firebase للدردشة';

  @override
  String get admin => 'مسؤل';

  @override
  String get cashStatus => 'الوضع النقدي';

  @override
  String get closeApp => 'أغلق التطبيق';

  @override
  String get youMustProvideValidCurrentPassword => 'يجب عليك توفير كلمة مرور الحالية صالحة';

  @override
  String get selectUserType => 'حدد نوع المستخدم';

  @override
  String get pleaseSelectCommission => 'الرجاء تحديد العمولة';

  @override
  String get copied => 'نسخ';

  @override
  String get pleaseContactYourAdmin => 'حسابك غير نشط. يرجى الاتصال بمسؤول النظام.';

  @override
  String get search => 'يبحث';

  @override
  String get wouldYouLikeToAssignThisBooking => 'هل ترغب في تعيين هذا الحجز؟';

  @override
  String get connect => 'يتصل';

  @override
  String get youAreNotConnectedWithChatServer => 'الاتصال بخادم الدردشة';

  @override
  String get tapBelowButtonToConnectWithOurChatServer => 'أنت غير متصل بخادم الدردشة. اضغط على الزر أدناه للاتصال وبدء الدردشة';

  // @override
  // String get youAreNotConnectedWithChatServer => 'أنت غير متصل بخادم الدردشة';

  // @override
  // String get tapBelowButtonToConnectWithOurChatServer =>
  //     'اضغط أدناه على الزر للاتصال بخادم الدردشة الخاص بنا';

  @override
  String get transactionId => 'رقم المعاملة';

  @override
  String get appliedTaxes => 'الضرائب التطبيقية';

  @override
  String get by => 'بواسطة';

  @override
  String get thisOrderWillBe => 'سيتم تمييز هذا الطلب كما هو مكتمل. هل ترغب في المتابعة؟';

  @override
  String get externalWallet => 'محفظة خارجية';

  @override
  String get start => 'يبدأ';

  @override
  String get digitalService => 'الخدمة الرقمية';

  @override
  String get digitalServiceSwitchSubText => 'حجز الخدمة الرقمية مع تحديثات الحالة الفورية في عملية قصيرة للتفاعلات المباشرة';

  @override
  String get filterAtLeastOneBookingStatusToast => 'يرجى التأكد من اختيار حالة حجز واحدة على الأقل';

  @override
  String get apply => 'يتقدم';

  @override
  String get clearFilter => 'مرشح واضح';

  @override
  String get bookingStatus => 'وضع الحجز';

  @override
  String get filterBy => 'مصنف بواسطة';

  @override
  String get cinetpayIsnTSupportedByCurrencies => 'CinetPay غير مدعوم من عملاتك';

  @override
  String get totalAmountShouldBeMoreThan => 'يجب أن يكون المبلغ الإجمالي أكثر من';

  @override
  String get totalAmountShouldBeLessThan => 'يجب أن يكون المبلغ الإجمالي أقل من';

  @override
  String get pleaseNoteThatAllServiceMarkedCompleted => 'يرجى ملاحظة أن جميع الوظائف الإضافية للخدمة محددة كما اكتملت!';

  @override
  String get serviceVisitType => 'نوع زيارة الخدمة';

  @override
  String get thisServiceIsOnlineRemote => 'سيتم إكمال هذه الخدمة عبر الإنترنت/عن بُعد.';

  @override
  String get visitOption => 'خيار زيارة';

  @override
  String get onSiteVisit => 'في الموقع زيارة';

  @override
  String get onlineRemoteService => 'خدمة عبر الإنترنت/عن بُعد';

  @override
  String get addOns => 'الوظائف الإضافية';

  @override
  String get serviceAddOns => 'الوظائف الإضافية للخدمة';

  @override
  String get writeHere => 'اكتب هنا';

  @override
  String get writeShortLineAbout => 'اكتب خطًا قصيرًا ، لماذا تختارني؟';

  @override
  String get reasonsToChooseYour => 'أسباب اختيار خدمتك';

  @override
  String get addReasons => 'أضف أسباب';

  @override
  String get addReason => 'أضف سببًا';

  @override
  String get writeReason => 'اكتب السبب';

  @override
  String get pleaseAddReason => 'الرجاء إضافة سبب!';

  @override
  String get isAvailableGoTo => 'متاح. انتقل إلى المتجر وتنزيل الإصدار الجديد من التطبيق.';

  @override
  String get later => 'لاحقاً';

  @override
  String get addonServices => 'خدمات Addon';

  @override
  String get paymentSuccess => 'الدفع الناجح';

  @override
  String get redirectingToBookings => 'إعادة توجيه الحجوزات ..';

  @override
  String get transactionIsInProcess => 'المعاملة قيد التشغيل ...';

  @override
  String get pleaseCheckThePayment => 'يرجى التحقق من طلب الدفع إلى رقمك';

  @override
  String get enterYourMsisdnHere => 'أدخل msisdn الخاص بك هنا';

  @override
  String get theTransactionIsStill => 'لا تزال المعاملة معالجة وهي في حالة غامضة. يرجى إجراء استفسار المعاملة لجلب حالة المعاملة.';

  @override
  String get transactionIsSuccessful => 'عملية ناجحة';

  @override
  String get incorrectPinHasBeen => 'تم إدخال رقم التعريف الشخصي غير الصحيح';

  @override
  String get theUserHasExceeded => 'لقد تجاوز المستخدم حد معاملة محفظته المسموح به';

  @override
  String get theAmountUserIs => 'المبلغ الذي يحاول المستخدم نقله أقل من الحد الأدنى المسموح به';

  @override
  String get userDidnTEnterThePin => 'لم يدخل المستخدم الرقم التعريف الشخصي';

  @override
  String get transactionInPendingState => 'المعاملة في حالة معلقة. يرجى التحقق بعد وقت ما';

  @override
  String get userWalletDoesNot => 'لا تحتوي محفظة المستخدم على ما يكفي من المال لتغطية المبلغ المستحق';

  @override
  String get theTransactionWasRefused => 'تم رفض الصفقة';

  @override
  String get thisIsAGeneric => 'هذا رفض عام له عدة أسباب محتملة';

  @override
  String get payeeIsAlreadyInitiated => 'تم بالفعل بدء Pleadee لـ Churn أو Barred أو غير مسجل على منصة Airtel Money';

  @override
  String get theTransactionWasTimed => 'تم توقيت المعاملة.';

  @override
  String get theTransactionWasNot => 'لم يتم العثور على المعاملة.';

  @override
  String get xSignatureAndPayloadDid => 'لا يتطابق التوقيع X والحمولة';

  @override
  String get encryptionKeyHasBeen => 'تم جلب مفتاح التشفير بنجاح';

  @override
  String get couldNotFetchEncryption => 'لا يمكن جلب مفتاح التشفير';

  @override
  String get transactionHasBeenExpired => 'انتهت صلاحية المعاملة';

  @override
  String get airtelMoneyPayment => 'Airtel الدفع المال';

  @override
  String get addonServiceName => 'اسم خدمة addon';

  @override
  String get editAddonService => 'تحرير خدمة Addon';

  @override
  String get addAddonService => 'أضف خدمة Addon';

  @override
  String get noteYouCanUpload => "ملاحظة: يمكنك تحميل الصورة باستخدام \ jpg \' ، \ 'png \' ، \ 'jpeg \' extensions ويمكنك تحديد صورة واحدة فقط";

  @override
  String get oppsLooksLikeYou => 'أوس! يبدو أنك لم تضاف أي خدمات الوظائف الإضافية حتى الآن.';

  @override
  String get ambiguous => 'غامض';

  @override
  String get success => 'نجاح';

  @override
  String get incorrectPin => 'دبوس غير صحيح';

  @override
  String get exceedsWithdrawalAmountLimitS => 'يتجاوز حد مبلغ السحب (ق)';

  @override
  String get invalidAmount => 'مبلغ غير صحيح';

  @override
  String get transactionIdIsInvalid => 'معرف المعاملة غير صالح';

  @override
  String get inProcess => 'تحت المعالجة';

  @override
  String get notEnoughBalance => 'لا يكفي التوازن';

  @override
  String get refused => 'رفض';

  @override
  String get doNotHonor => 'لا تتباهي';

  @override
  String get transactionNotPermittedTo => 'المعاملة غير مسموح بالوظف';

  @override
  String get transactionTimedOut => 'المعاملة توقيت خارج';

  @override
  String get transactionNotFound => 'المعاملة غير موجودة';

  @override
  String get forBidden => 'مُحرَّم';

  @override
  String get successfullyFetchedEncryptionKey => 'مفتاح التشفير بنجاح';

  @override
  String get errorWhileFetchingEncryption => 'خطأ أثناء جلب مفتاح التشفير';

  @override
  String get transactionExpired => 'انتهت صلاحية المعاملة';

  @override
  String get pleaseSelectAService => 'الرجاء تحديد خدمة';

  @override
  String get verifyEmail => 'التحقق من البريد الإلكتروني';

  @override
  String get verified => 'تم التحقق';

  @override
  String get minRead => 'اقرأ مين';

  @override
  String get loadingChats => 'تحميل الدردشات ...';

  @override
  String get monthly => 'شهريا';

  @override
  String get mon => 'الاثنين';

  @override
  String get tue => 'الثلاثاء';

  @override
  String get wed => 'تزوج';

  @override
  String get thu => 'الخميس';

  @override
  String get fri => 'الجمعة';

  @override
  String get sat => 'قعد';

  @override
  String get sun => 'شمس';

  @override
  String get jan => 'يناير';

  @override
  String get feb => 'فبراير';

  @override
  String get mar => 'مارس';

  @override
  String get apr => 'أبريل';

  @override
  String get may => 'يمكن';

  @override
  String get jun => 'يونيو';

  @override
  String get july => 'يوليو';

  @override
  String get aug => 'أغسطس';

  @override
  String get sept => 'سبتمبر';

  @override
  String get oct => 'أكتوبر';

  @override
  String get nov => 'نوفمبر';

  @override
  String get dec => 'ديسمبر';

  @override
  String get pushNotification => 'دفع الإخطار';

  @override
  String get sentYouAMessage => 'أرسلت لك رسالة';

  @override
  String get deleteMessage => 'حذف رسالة';

  @override
  String get removeThisFile => 'إزالة هذا الملف';

  @override
  String get areYouSureWantToRemoveThisFile => 'هل أنت متأكد أنك تريد إزالة هذا الملف؟';

  @override
  String get sendMessage => 'أرسل رسالة';

  @override
  String get handymanLocation => 'موقع العامل الماهر';

  @override
  String get track => 'مسار';

  @override
  String get trackHandymanLocation => 'تتبع موقع العامل الماهر';

  @override
  String get lastUpdatedAt => 'अंतिम बार अद्यतन किया गया:';

  String get lblBankDetails => "التفاصيل المصرفية";

  @override
  String get withdraw => "ينسحب";

  @override
  String get availableBalance => "الرصيد المتوفر";

  @override
  String get withdrawRequest => "طلب سحب";

  @override
  String get chooseBank => "اختر البنك";

  @override
  String get egCentralNationalBank => 'على سبيل المثال "البنك الوطني المركزي"';

  @override
  String get addBank => "أضف البنك";

  @override
  String get successful => 'ناجح';

  @override
  String get yourWithdrawalRequestHasBeenSuccessfullySubmitted => 'لقد تم إرسال طلب السحب الخاص بك بنجاح.';

  @override
  String get done => "منتهي";

  @override
  String get requestList => "قائمة الطلبات";

  @override
  String get filter => 'منقي';

  @override
  String get reset => "إعادة ضبط";

  @override
  String get bankList => "قائمة البنك";

  @override
  String get lbldefault => "تقصير";

  @override
  String get setAsDefault => "تعيين كافتراضي";

  @override
  String get branchName => "اسم الفرع";

  @override
  String get aadharNumber => "رقم أدهار";

  @override
  String get panNumber => "رقم الحساب الجاري";

  @override
  String get lblPleaseEnterAccountNumber => "الرجاء إدخال رقم الحساب";

  @override
  String get lblAccountNumberMustContainOnlyDigits => "يجب أن يحتوي رقم الحساب على أرقام فقط";

  @override
  String get lblAccountNumberMustBetween11And16Digits => "يجب أن يتراوح رقم الحساب بين 11 و16 رقمًا";

  @override
  String get noBankDataTitle => "لم يتم العثور على بيانات البنك";

  @override
  String get noBankDataSubTitle => "لم تقم بإضافة البنك بعد";

  @override
  String get eg3000 => 'على سبيل المثال "3000"';

  @override
  String get pleaseAddLessThanOrEqualTo => "الرجاء إضافة أقل من أو يساوي";

  @override
  String get deleteBankTitle => 'هل أنت متأكد أنك تريد حذف هذا البنك؟';

  @override
  String get debit => 'دَين';

  @override
  String get credit => 'ائتمان';

  @override
  String get fullNameOnBankAccount => 'الاسم الكامل على الحساب البنكي';

  @override
  String get updateYourLocation => 'قم بتحديث موقعك';

  @override
  String get lbHours => "ساعات";

  @override
  String get lbMinutes => "دقائق";

  @override
  String get handymanCommission => 'لجنة العامل الماهر';

  @override
  String get commission => 'عمولة';

  @override
  String get noCommissionTypeListFound => 'لم يتم العثور على قائمة نوع العمولة';

  @override
  String get typeName => 'اكتب الاسم';

  @override
  String get addHandymanCommission => 'إضافة لجنة العامل الماهر';

  @override
  String get editHandymanCommission => 'تحرير لجنة العامل الماهر';

  @override
  String get enterValidCommissionValue => 'أدخل قيمة العمولة الصالحة';

  @override
  String get percentage => 'نسبة مئوية';

  @override
  String get selectStatus => 'حدد الحالة';

  @override
  String get youCanTUpdateDeleted => 'لا يمكنك تحديث العناصر المحذوفة';

  @override
  String get thisCommissionHasBeen => 'تم إنشاء هذه اللجنة من قبل المشرف';

  @override
  String get copyMessage => 'نسخ الرسالة';

  @override
  String get transactions => 'المعاملات';

  @override
  String get thisYear => 'هذا العام';

  @override
  String get thisMonth => 'هذا الشهر';

  @override
  String get thisWeek => 'هذا الاسبوع';

  @override
  String get providerList => 'قائمة مقدمي الخدمة';

  @override
  String get walletBalance => 'رصيد المحفظة';

  @override
  String get remainingPayout => 'الدفع المتبقي';

  @override
  String get totalRevenue => 'إجمالي الإيرادات';

  @override
  String get totalActiveCount => 'إجمالي عدد النشطين:';

  @override
  String get completedBookings => 'الحجوزات المكتملة';

  @override
  String get pickAProviderYou => 'اختر المزود الذي ترغب في العمل معه';

  @override
  String get selectedProvider => 'المزود المختار';

  @override
  String get youHavePermanentlyDenied => 'لقد رفضت إذن تحديد الموقع بشكل دائم، يرجى السماح بتتبع الموقع المباشر من إعداداتك';

  @override
  String get open => 'يفتح';

  @override
  String get closed => 'مغلق';

  @override
  String get createBy => 'إنشاء بواسطة';

  @override
  String get repliedBy => 'تم الرد بواسطة';

  @override
  String get closedBy => 'مغلق بواسطة';

  @override
  String get helpDesk => 'مكتب المساعدة';

  @override
  String get addNew => 'أضف جديد';

  @override
  String get queryYet => 'الاستعلام بعد';

  @override
  String get toSubmitYourProblems => 'لإرسال مشاكلك، ما عليك سوى الضغط على زر ""إضافة"" وشرح مخاوفك';

  @override
  String get noRecordsFoundFor => 'لم يتم العثور على سجلات ل';

  @override
  String get queries => 'الاستعلامات.';

  @override
  String get noActivityYet => 'لا يوجد نشاط حتى الآن';

  @override
  String get noRecordsFound => 'لم يتم العثور على سجلات';

  @override
  String get reply => 'رد';

  @override
  String get eGDuringTheService => 'على سبيل المثال أثناء الخدمة، تعرض الأثاث للتلف عن طريق الخطأ.';

  @override
  String get doYouWantClosedThisQuery => 'هل تريد إغلاق هذا الاستعلام';

  @override
  String get markAsClosed => 'وضع علامة كمغلق';

  @override
  String get youCanMarkThis => 'يمكنك وضع علامة ""مغلق"" على هذا إذا كنت راضيًا عن إجابتنا';

  @override
  String get subject => 'موضوع';

  @override
  String get eGDamagedFurniture => 'على سبيل المثال الأثاث التالف';

  @override
  String get closedOn => 'مغلق في:';

  @override
  String get on => 'على';

  @override
  String get showMessage => 'إظهار الرسالة';

  @override
  String get viewDetail => 'عرض التفاصيل';

  @override
  String get serviceProofMediaUploadNote => 'ملحوظة: يمكنك تحميل صورة بامتداد ""JPG""، ""PNG""، ""JPEG"" ويمكنك تحديد صور متعددة';

  @override
  String get uploadMedia => 'تحميل الوسائط';

  @override
  String get viewStatus => 'عرض الحالة';

  @override
  String get email => 'بريد إلكتروني:';

  @override
  String get at => 'في';

  @override
  String get general => 'عام';

  @override
  String get other => 'آخر';

  @override
  String get setting => 'جلسة';

  @override
  String get viewBreakdown => 'عرض الانهيار';

  @override
  String get totalAmount => 'المبلغ الإجمالي:';

  @override
  String get role => 'دور';

  @override
  String get paymentBreakdown => 'انهيار الدفع';

  @override
  String get paymentType => 'نوع الدفع';

  @override
  String get dateRange => 'النطاق الزمني';

  @override
  String get providerNotFound => 'لم يتم العثور على الموفر';

  @override
  String get noPaymentMethodsFound => 'لم يتم العثور على طرق الدفع';

  @override
  String get handymanNotFound => 'لم يتم العثور على العامل الماهر';

  @override
  String get selectStartDateEndDate => 'حدد تاريخ البدء وتاريخ الانتهاء';

  @override
  String get customerNotFound => 'لم يتم العثور على العميل';

  @override
  String get to => 'ل';

  @override
  String get chooseYourDateRange => 'اختر النطاق الزمني الخاص بك';

  @override
  String get advancedRefund => 'استرداد متقدم';

  @override
  String get taxAmount => 'مبلغ الضريبة';

  @override
  String get lblReassign => 'إعادة التعيين';

  @override
  String get handymanPayoutList => 'قائمة دفع تعويضات العامل الماهر';

  @override
  String get earningDetails => 'تفاصيل الكسب';

  @override
  String get adminEarning => 'أرباح المشرف';

  @override
  String get handymanName => 'اسم العامل الماهر';

  @override
  String get totalEarning => 'إجمالي الربح';

  @override
  String get myEarning => 'كسبي';

  @override
  String get handymanPayDue => 'العامل الماهر الدفع المستحق';

  @override
  String get handymanPaidAmount => 'العامل الماهر المبلغ المدفوع';

  @override
  String get payout => 'الدفع';

  @override
  String get addHandymanPayout => 'إضافة تعويضات العامل الماهر';

  @override
  String get selectMethod => 'حدد الطريقة';

  @override
  String get handymanEarning => 'كسب العامل الماهر';

  @override
  String get handymanEarnings => 'أرباح العامل الماهر';

  @override
  String get noPayoutFound => 'لم يتم العثور على دفع تعويضات';

  @override
  String get handymanEarningList => 'قائمة أرباح العامل الماهر';

  @override
  String get permissionDeniedUnableTo => 'تم رفض الإذن! غير قادر على تحرير العامل الماهر';

  @override
  String get passwordLengthShouldBe => 'يجب أن يكون طول كلمة المرور من 8 إلى 12 حرفًا.';
}
