import 'package:handyman_provider_flutter/locale/base_language.dart';

class LanguageEn extends Languages {
  @override
  String planAboutToExpire(int days) => 'Your Plan Is About to Expire In $days Days';

  @override
  String get appName => 'Provider';

  @override
  String get provider => 'Provider';

  @override
  String get lblShowingOnly4Handyman => 'Showing Only 4 Handyman';

  @override
  String get lblRecentlyOnlineHandyman => 'Recently Online Handyman';

  @override
  String get lblStartDrive => 'Start Drive';

  @override
  String get handyman => 'Handyman';

  @override
  String get signIn => 'Sign In';

  @override
  String get signUp => 'Sign Up';

  @override
  String get hintFirstNameTxt => 'First Name';

  @override
  String get hintLastNameTxt => 'Last Name';

  @override
  String get hintContactNumberTxt => 'Contact Number';

  @override
  String get hintEmailAddressTxt => 'Email Address';

  @override
  String get hintUserNameTxt => 'User Name';

  @override
  String get hintReenterPasswordTxt => 'Re-enter Password';

  @override
  String get confirm => 'Confirm';

  @override
  String get forgotPassword => 'Forgot Password?';

  @override
  String get alreadyHaveAccountTxt => 'Already have an Account';

  @override
  String get rememberMe => 'Remember Me';

  @override
  String get forgotPasswordTitleTxt => 'Enter your email address';

  @override
  String get resetPassword => 'Reset Password';

  @override
  String get editProfile => 'Edit profile';

  @override
  String get saveChanges => 'Save Changes';

  @override
  String get camera => 'Camera';

  @override
  String get language => 'App Language';

  @override
  String get appTheme => 'App Theme';

  @override
  String get bookingHistory => 'Booking History';

  @override
  String get logout => 'Logout';

  @override
  String get afterLogoutTxt => 'Do you want to logout from the app? You can always logged in again!';

  @override
  String get chooseTheme => 'Choose the App Theme';

  @override
  String get selectCountry => 'Select Country';

  @override
  String get selectState => 'Select State';

  @override
  String get selectCity => 'Select City';

  @override
  String get changePassword => 'Change Password';

  @override
  String get passwordNotMatch => "Password does not match";

  @override
  String get doNotHaveAccount => "Don't have an account?";

  @override
  String get hintNewPasswordTxt => "New Password";

  @override
  String get hintOldPasswordTxt => "Old Password";

  @override
  String get review => 'Reviews';

  @override
  String get notification => 'Notifications';

  @override
  String get accept => 'Accept';

  @override
  String get decline => 'Decline';

  @override
  String get noDataFound => 'No Data Found';

  @override
  String get pending => 'Pending';

  @override
  String get darkMode => 'Dark Mode';

  @override
  String get lightMode => 'Light Mode';

  @override
  String get systemDefault => 'System Mode';

  @override
  String get confirmationRequestTxt => 'Are you sure want to perform this action?';

  @override
  String get notAvailable => 'Not Available';

  @override
  String get lblGallery => "Gallery";

  @override
  String get cantLogin => "Can't Login";

  @override
  String get pleaseContactAdmin => 'Please contact with Admin';

  @override
  String get lblOk => 'Ok';

  @override
  String get paymentStatus => 'Payment Status';

  @override
  String get paymentMethod => 'Payment Method ';

  @override
  String get hintAddress => 'Enter Address';

  @override
  String get quantity => 'Quantity';

  @override
  String get lblYes => 'Yes';

  @override
  String get lblNo => 'No';

  @override
  String get lblReason => 'Reason';

  @override
  String get lblSelectHandyman => 'Please Select Handyman';

  @override
  String get lblAssign => 'Assign';

  @override
  String get lblCall => 'Call';

  @override
  String get lblAssignHandyman => 'Assign Handyman';

  @override
  String get lblAssigned => 'Assigned';

  @override
  String get viewAll => 'View all';

  @override
  String get lblMonthlyRevenue => 'Monthly Revenue';

  @override
  String get lblRevenue => 'Revenue';

  @override
  String get lblAddHandyman => "Add Handyman";

  @override
  String get lblBooking => 'Bookings';

  @override
  String get lblTotalBooking => 'Total Bookings';

  @override
  String get lblTotalService => 'Total Service';

  @override
  String get lblTotalHandyman => 'Total Handyman';

  @override
  String get monthlyEarnings => 'Monthly Earnings';

  @override
  String get lblPayment => 'Payments';

  @override
  String get lblBookingID => 'Booking ID';

  @override
  String get lblPaymentID => 'Payment ID';

  @override
  String get lblAmount => 'Amount';

  @override
  String get hintAddService => 'Add Service';

  @override
  String get hintServiceName => 'Service Name';

  @override
  String get hintSelectCategory => 'Select Category';

  @override
  String get hintSelectType => 'Select Type';

  @override
  String get hintSelectStatus => 'Select Status';

  @override
  String get hintPrice => 'Price';

  @override
  String get hintDiscount => 'Discount';

  @override
  String get hintDuration => 'Duration';

  @override
  String get hintDescription => 'Description';

  @override
  String get hintSetAsFeature => 'Set as Feature';

  @override
  String get hintAdd => 'Add';

  @override
  String get hintChooseImage => 'Choose Image';

  @override
  String get customer => 'Customer';

  @override
  String get lblProfile => 'Profile';

  @override
  String get lblAllHandyman => "Handyman List";

  @override
  String get lblTime => 'Time';

  @override
  String get lblMyService => 'My Services';

  @override
  String get lblAllService => 'All Service';

  @override
  String get lblChat => 'Chat';

  @override
  String get selectAddress => 'Select Service Addresses';

  @override
  String get btnSave => 'Save';

  @override
  String get editAddress => 'Edit Service Address';

  @override
  String get lblUpdate => 'Update';

  @override
  String get lblEdit => 'Edit';

  @override
  String get lblDelete => 'Delete';

  @override
  String get lblServiceAddress => 'Service Addresses';

  @override
  String get lblServices => 'Services';

  @override
  String get lblEditService => 'Edit Service';

  @override
  String get selectImgNote => 'Note: You can upload images with \'jpg\', \'png\', \'jpeg\' extensions & you can select multiple images';

  @override
  String get lblDurationHr => 'Duration : Hours';

  @override
  String get lblDurationMin => 'Duration : Minute';

  @override
  String get lblWaitForAcceptReq => 'Please wait for admin to accept your request';

  @override
  String get lblAddServiceAddress => 'Add Service Address';

  @override
  String get errorPasswordLength => 'Password length should be more than';

  @override
  String get hintPassword => 'Password';

  @override
  String get hintRequired => 'This field is required';

  @override
  String get lblUnAuthorized => "Demo user cannot be granted for this action";

  @override
  String get btnVerifyId => "Verify Your Id";

  @override
  String get confirmationUpload => "Are you sure you want to upload this document?";

  @override
  String get toastSuccess => "Provider Document has been save successfully";

  @override
  String get lblSelectDoc => "Select Document";

  @override
  String get lblAddDoc => "Add Documents";

  @override
  String get lblRateUs => "Rate us";

  @override
  String get lblTermsAndConditions => 'Terms & Conditions';

  @override
  String get lblPrivacyPolicy => "Privacy Policy";

  @override
  String get lblHelpAndSupport => 'Help & Support';

  @override
  String get lblAbout => "About";

  @override
  String get lblProviderType => "Provider Type";

  @override
  String get lblMyCommission => "My Commission";

  @override
  String get lblTaxes => "Taxes";

  @override
  String get lblTaxName => "Tax Name";

  @override
  String get lblMyTax => "My Tax";

  @override
  String get lblLoginTitle => "Hello Again !";

  @override
  String get lblLoginSubtitle => "Welcome Back, You Have Been Missed For A Long Time";

  @override
  String get lblSignupTitle => "Hello User !";

  @override
  String get lblSignupSubtitle => "Create Your Account for Better Experience";

  @override
  String get lblSignup => "Sign Up";

  @override
  String get lblUserType => "User Type";

  @override
  String get lblPurchaseCode => "Purchase Full Source Code";

  @override
  String get lblRating => "Rating";

  @override
  String get lblOff => "Off";

  @override
  String get lblHr => "hr";

  @override
  String get lblDate => "Date";

  @override
  String get lblAboutHandyman => "About Handyman";

  @override
  String get lblAboutCustomer => "About Customer";

  @override
  String get lblPaymentDetail => "Payment Detail";

  @override
  String get lblId => "ID";

  @override
  String get lblMethod => "Method";

  @override
  String get lblStatus => "Status";

  @override
  String get lblPriceDetail => "Price Detail";

  @override
  String get lblSubTotal => "Sub Total";

  @override
  String get lblTax => "Tax";

  @override
  String get lblCoupon => "Coupon";

  @override
  String get lblTotalAmount => "Total Amount";

  @override
  String get lblOnBasisOf => "On basis of";

  @override
  String get lblCheckStatus => "Check Status";

  @override
  String get lblCancel => "Cancel";

  @override
  String get lblUnreadNotification => "Unread Notification";

  @override
  String get lblMarkAllAsRead => "Mark all as Read";

  @override
  String get lblCloseAppMsg => "Press back again to exit app";

  @override
  String get lblAddress => "Address";

  @override
  String get lblType => "Type";

  @override
  String get lblHandymanType => "Handyman Type";

  @override
  String get lblFixed => "Fixed";

  @override
  String get lblHello => "Hello";

  @override
  String get lblWelcomeBack => "Welcome back!";

  @override
  String get lblNoReviewYet => "No Review Yet";

  @override
  String get lblWaitingForResponse => "Waiting for response";

  @override
  String get lblConfirmPayment => "Confirm Payment";

  @override
  String get lblDelivered => "Delivered";

  @override
  String get lblDay => "Day";

  @override
  String get lblYear => "Year";

  @override
  String get lblExperience => "Experience";

  @override
  String get lblOf => "(s) of";

  @override
  String get lblSelectAddress => "Select Address";

  @override
  String get lblOppS => "Opps";

  @override
  String get lblNoInternet => "Something wrong with your connection, Please try again.";

  @override
  String get lblRetry => "RETRY";

  @override
  String get lblServiceStatus => "Service Status";

  @override
  String get lblMemberSince => "Member Since";

  @override
  String get lblDeleteAddress => "Delete Address";

  @override
  String get lblDeleteAddressMsg => "Do you want to delete this address?";

  @override
  String get lblChoosePaymentMethod => "Choose Payment Method";

  @override
  String get lblNoPayments => "No Payments";

  @override
  String lblPayWith(String title) => "Do you want to pay with $title?";

  @override
  String get lblProceed => "Proceed";

  @override
  String get lblPricingPlan => "Pricing Plan";

  @override
  String get lblSelectPlan => "Ready to get started?";

  @override
  String get lblMakePayment => "Make Payment";

  @override
  String get lblRestore => "Restore";

  @override
  String get lblForceDelete => "Force Delete";

  @override
  String get lblActivated => "Activated";

  @override
  String get lblDeactivated => "Deactivated";

  @override
  String get lblNoDescriptionAvailable => "No Description Available";

  @override
  String get lblFAQs => "FAQs";

  @override
  String get lblGetDirection => "Get Direction";

  @override
  String get lblDeleteTitle => "Oh No, You Are Leaving!";

  @override
  String get lblDeleteSubTitle => "Do you want to logout?";

  @override
  String get lblUpcomingServices => "Upcoming Services";

  @override
  String get lblTodayServices => "Today's Bookings";

  @override
  String get lblPlanExpired => "Opps! Plan Expired";

  @override
  String get lblPlanSubTitle => "Your Previous Plan Is Expired";

  @override
  String get btnTxtBuyNow => "Buy Now";

  @override
  String get lblChooseYourPlan => "Choose Your Plan";

  @override
  String get lblRenewSubTitle => "Buy new plan to get new service bookings";

  @override
  String get lblReminder => "Reminder";

  @override
  String get lblRenew => "Renew";

  @override
  String get lblCurrentPlan => "Current Plan";

  @override
  String get lblValidTill => "Valid Till";

  @override
  String get lblSearchHere => "Search here...";

  @override
  String get lblEarningList => "Earning List";

  @override
  String get lblSubscriptionTitle => "Do want to cancel current plan?";

  @override
  String get lblPlan => "Plan";

  @override
  String get lblCancelPlan => "Cancel Plan";

  @override
  String get lblSubscriptionHistory => "Subscription History";

  @override
  String get lblTrashHandyman => "Handyman has been Trash successfully";

  @override
  String get lblPlsSelectAddress => "Please Selected Address";

  @override
  String get lblPlsSelectCategory => "Please Selected Category";

  @override
  String get lblEnterHours => "Enter Hours Up To 24 Hours";

  @override
  String get lblEnterMinute => "Enter Minute Up To 60 Minute";

  @override
  String get lblSelectSubCategory => "Select SubCategory";

  @override
  String get lblServiceProof => "Service Proof";

  @override
  String get lblTitle => "Title";

  @override
  String get lblAddImage => "Add Image";

  @override
  String get lblSubmit => "Submit";

  @override
  String get lblWalletHistory => "Wallet History";

  @override
  String get lblServiceRatings => "Service Ratings";

  @override
  String get lblWallet => "Wallet";

  @override
  String get lblSelectCommission => "Select Commission";

  @override
  String get lblIAgree => "I agree to the";

  @override
  String get lblTermsOfService => "Terms of Service";

  @override
  String get lblLoginAgain => "Please Login Again";

  @override
  String get lblTermCondition => "Please accept terms and condition";

  @override
  String get lblServiceTotalTime => "Service Total Time";

  @override
  String get lblHelpLineNum => "Helpline Number";

  @override
  String get lblReasonCancelling => "Reason for cancelling this booking";

  @override
  String get lblReasonRejecting => "Reason for rejecting this booking";

  @override
  String get lblFailed => "Reason why this booking is failed";

  @override
  String get lblDesignation => "Designation";

  @override
  String get lblHandymanIsOffline => "Handyman is Offline";

  @override
  String get lblDoYouWantToRestore => "Do you want to Restore?";

  @override
  String get lblDoYouWantToDeleteForcefully => "Do you want to delete Forcefully?";

  @override
  String get lblDoYouWantToDelete => "Do you want to delete?";

  @override
  String get lblPleaseEnterMobileNumber => "Please Enter Mobile Number";

  @override
  String get lblDangerZone => "Danger Zone";

  @override
  String get lblDeleteAccount => "Delete Account";

  @override
  String get lblDeleteAccountConformation => "Your account will be deleted permanently. Your Data will not be Restored Again.";

  @override
  String get lblUnderMaintenance => "Under Maintenance...";

  @override
  String get lblCatchUpAfterAWhile => "Catch Up After A While";

  @override
  String get lblRecheck => "Recheck";

  @override
  String get lblTrialFor => "Trial For";

  @override
  String get lblDays => "Day(s)";

  @override
  String get lblFreeTrial => "Free Trial";

  @override
  String get lblAtLeastOneImage => "Choose at-least One Image";

  @override
  String get lblService => "Service";

  @override
  String get lblNewUpdate => "New Update";

  @override
  String get lblOptionalUpdateNotify => "Optional Update Notify";

  @override
  String get lblAnUpdateTo => "An Update to ";

  @override
  String get lblIsAvailableWouldYouLike => "is available. Would you like to update?";

  @override
  String lblAreYouSureYouWantToAssignThisServiceTo(String name) => "Do you want to assign this service to $name?";

  @override
  String get lblAreYouSureYouWantToAssignToYourself => "Do you want to Assign to yourself?";

  @override
  String get lblAssignToMyself => "Assign to Myself";

  @override
  String get lblFree => "Free";

  @override
  String get lblMyProvider => "My Provider";

  @override
  String get lblAvailableStatus => "Available Status";

  @override
  String get lblYouAre => "You are";

  @override
  String get lblEmailIsVerified => "Email is verified";

  @override
  String get lblHelp => "Help";

  @override
  String get lblAddYourCountryCode => "Add your country code";

  @override
  String get lblRegistered => "registered";

  @override
  String get lblRequiredAfterCountryCode => "required after country code";

  @override
  String get lblExtraCharges => "Extra Charges";

  @override
  String get lblAddExtraCharges => "Add Extra Charges";

  @override
  String get lblCompleted => "Complete";

  @override
  String get lblAddExtraChargesDetail => "Add Charges Detail";

  @override
  String get lblEnterExtraChargesDetail => "Enter Charges Detail";

  @override
  String get lblTotalCharges => "Total Extra Charges";

  @override
  String get lblSuccessFullyAddExtraCharges => "SuccessFully Add Extra Charges";

  @override
  String get lblChargeName => "Charge Detail";

  @override
  String get lblPrice => "Price";

  @override
  String get lblEnterAmount => "Enter Amount";

  @override
  String get lblHourly => "Hourly";

  @override
  String get noBookingTitle => "No Booking Found";

  @override
  String get noBookingSubTitle => "Looks like your customer haven't book your services yet";

  @override
  String get noNotificationTitle => "It Looks A Bit Empty Here";

  @override
  String get noNotificationSubTitle => "We'll notify you once we have something for you";

  @override
  String get noHandymanAvailable => "Handyman Not Available";

  @override
  String get noHandymanYet => "No Handyman Yet";

  @override
  String get noHandymanSubTitle => "Please check and handyman status active first";

  @override
  String get noServiceFound => "No Service Found";

  @override
  String get noServiceSubTitle => "Hurry Up! Add services for customer and expand your work";

  @override
  String get noServiceAddressTitle => "Service Address Not Found";

  @override
  String get noServiceAddressSubTitle => "Add your service address first then it will appear here";

  @override
  String get noSubscriptionPlan => "No Subscription Plan Here";

  @override
  String get noSubscriptionFound => "No Subscription Found";

  @override
  String get noSubscriptionSubTitle => "You haven't subscribe any subscription";

  @override
  String get noTexesFound => "No Taxes Found";

  @override
  String get noWalletHistoryTitle => "No Wallet History Found";

  @override
  String get noWalletHistorySubTitle => "You didn't top-up yet. Top-up your wallet to see here";

  @override
  String get noExtraChargesHere => "No Extra Charges Here";

  @override
  String get getYourFirstReview => "Get your first review";

  @override
  String get ratingViewAllSubtitle => "Capture high-quality product reviews for your service";

  @override
  String get noDocumentFound => "No Document Found";

  @override
  String get noDocumentSubTitle => "No document for verify";

  @override
  String get noConversation => "No Conversation";

  @override
  String get jobRequestList => 'Job Request List';

  @override
  String get bidList => 'Bid List';

  @override
  String get bid => 'Bid';

  @override
  String get postJobTitle => 'Post Job Title';

  @override
  String get postJobDescription => 'Post Job Description';

  @override
  String get jobPrice => 'Job Price';

  @override
  String get estimatedPrice => 'Estimated Price';

  @override
  String get assignedProvider => 'Assigned Provider';

  @override
  String get giveYourEstimatePriceHere => 'Give your estimate price here';

  @override
  String get pleaseEnterValidBidPrice => 'Please enter valid Bid price';

  @override
  String get yourPriceShouldNotBeLessThan => 'Your price should not be less than';

  @override
  String get enterBidPrice => 'Enter Bid Price';

  @override
  String get myBid => 'My Bid';

  @override
  String get inputMustBeNumberOrDigit => 'Input must be number or digit';

  @override
  String get requiredAfterCountryCode => 'required after country code';

  @override
  String get thisSlotIsNotAvailable => 'This Slot is not available';

  @override
  String get notes => 'Notes:';

  @override
  String get timeSlotsNotes1 => 'Time Slots are only for Providers.';

  @override
  String get timeSlotsNotes2 => 'You can set Time Slot availability for each Service.';

  @override
  String get timeSlotsNotes3 => 'Customer will be able to see the Time Slots only when you enable it in a particular Service.';

  @override
  String get noSlotsAvailable => 'No Slots Available';

  @override
  String get timeSlots => 'Time Slots';

  @override
  String get selectYourDay => 'Select Your Day';

  @override
  String get chooseTime => 'Choose Time';

  @override
  String get copyTo => 'Copy To';

  @override
  String get pleaseWaitWhileWeChangeTheStatus => 'Please wait while we change the status';

  @override
  String get myTimeSlots => 'My Time Slots';

  @override
  String get day => 'Day';

  @override
  String get pleaseSelectServiceAddresses => 'Please Select Service Addresses';

  @override
  String get pleaseSelectImages => 'Please Select images';

  @override
  String get timeSlotAvailable => 'Time Slot Available';

  @override
  String get doesThisServicesContainsTimeslot => 'Does this services contains timeslot';

  @override
  String get pleaseEnterTheDefaultTimeslotsFirst => 'Please enter the default timeslots First';

  @override
  String get chooseAction => 'Choose Action';

  @override
  String get chooseImage => 'Choose Image';

  @override
  String get removeImage => 'Remove Image';

  @override
  String get availableAt => 'Available At';

  @override
  String get clearChat => 'Clear chat';

  @override
  String get internetNotAvailable => 'Your internet appears to be offline';

  @override
  String get pleaseTryAgain => 'Please try again';

  @override
  String get somethingWentWrong => 'Something Went Wrong';

  @override
  String get upcomingBookings => 'Upcoming Bookings';

  @override
  String get postJob => 'Post Job';

  @override
  String get categoryBasedPackage => 'Category based Package';

  @override
  String get subTitleOfSelectService => 'The feature allows you to select single or multiple services from a single category';

  @override
  String get enabled => 'Enabled';

  @override
  String get disabled => 'Disabled';

  @override
  String get doYouWantTo => 'Do you want to';

  @override
  String get enable => 'enable';

  @override
  String get disable => 'disable';

  @override
  String get package => 'Package';

  @override
  String get packages => 'Packages';

  @override
  String get packageService => 'Package Service';

  @override
  String get confirmationRemovePackage => 'Do want remove this service from the package?';

  @override
  String get packageName => 'Package Name';

  @override
  String get selectService => 'Select Service';

  @override
  String get packageDescription => 'Package Description';

  @override
  String get packagePrice => 'Package Price';

  @override
  String get startDate => 'Start Date';

  @override
  String get endDate => 'End Date';

  @override
  String get pleaseSelectService => 'Please Select Service';

  @override
  String get pleaseEnterTheEndDate => 'Please enter the end date';

  @override
  String get editPackage => 'Edit Package';

  @override
  String get addPackage => 'Add Package';

  @override
  String get areYouSureWantToDeleteThe => 'Are you sure want to delete the';

  @override
  String get packageNotAvailable => 'Package Not Available';

  @override
  String get includedInThisPackage => 'Included in this Package';

  @override
  String get packageServicesWillAppearHere => 'Package services will appear here';

  @override
  String get showingFixPriceServices => 'Showing fix price Services (Excluded Hourly Services)';

  @override
  String get pleaseSelectTheCategory => 'Please Select The Category';

  @override
  String get lblInvalidTransaction => 'Invalid Transaction';

  @override
  String get youWillGetTheseServicesWithThisPackage => 'You will get these services with this package';

  @override
  String get lblSearchFullAddress => 'Search Full Address';

  @override
  String get lblPleaseSelectCity => 'Please select the city';

  @override
  String get lblChooseOneImage => 'Choose at-least one image';

  @override
  String get lblNoTransactionFound => 'No Transaction Found';

  @override
  String get lblSubTitleNoTransaction => 'Nothing found in your history yet. Complete services first and then get payment';

  @override
  String get lblCheckOutWithCinetPay => 'Checkout with CinetPay';

  @override
  String get yourPaymentFailedPleaseTryAgain => 'Your payment failed please try again';

  @override
  String get yourPaymentHasBeenMadeSuccessfully => 'Your payment has been made successfully';

  @override
  String get lblTransactionFailed => 'Transaction Failed';

  @override
  String get lblTransactionCancelled => 'Transaction cancelled';

  @override
  String get lblStripeTestCredential => 'Testing Credential cannot pay more then 500';

  @override
  String get lblSuccessFullyActivated => 'is successfully activated';

  @override
  String get lblNoTaxesFound => 'No Taxes Found';

  @override
  String get lblConfirmationForDeleteMsg => 'Do you want to delete the message?';

  @override
  String get lblImage => 'Image';

  @override
  String get lblVideo => 'Video';

  @override
  String get lblAudio => 'Audio';

  @override
  String get lblMessage => 'Message';

  @override
  String get chatCleared => 'Chat Cleared';

  @override
  String get lblNoEarningFound => 'No Earning Found';

  @override
  String get lblNoUserFound => 'No User Found';

  @override
  String get lblTokenExpired => 'Token Expired';

  @override
  String get lblFailedToLoadPredictions => 'Failed to load predictions';

  @override
  String get personalInfo => 'Personal Info';

  @override
  String get essentialSkills => 'Essential Skills';

  @override
  String get knownLanguages => 'Known Languages';

  @override
  String get addEssentialSkill => 'Add Essential Skill';

  @override
  String get addKnownLanguage => 'Add Known Language';

  @override
  String get authorBy => 'Author By';

  @override
  String get views => 'Views';

  @override
  String get deleteBlogTitle => 'Do want to delete this blog?';

  @override
  String get enterBlogTitle => 'Enter your blog title';

  @override
  String get updateBlog => 'Update Blog';

  @override
  String get addBlog => 'Add Blog';

  @override
  String get blogs => 'Blogs';

  @override
  String get noBlogsFound => 'No Blogs Found';

  @override
  String get aboutYou => 'About you';

  @override
  String get pleaseAddKnownLanguage => 'Please add known language';

  @override
  String get pleaseAddEssentialSkill => 'Please add essential skill';

  @override
  String get published => 'Published';

  @override
  String get clearChatMessage => 'Do you want to clear this chat?';

  @override
  String get all => 'All';

  @override
  String get accepted => 'Accepted';

  @override
  String get onGoing => 'On Going';

  @override
  String get inProgress => 'In Progress';

  @override
  String get hold => 'Hold';

  @override
  String get cancelled => 'Cancelled';

  @override
  String get rejected => 'Rejected';

  @override
  String get failed => 'Failed';

  @override
  String get completed => 'Completed';

  @override
  String get pendingApproval => 'Pending Approval';

  @override
  String get waiting => 'Waiting';

  @override
  String get paid => 'Paid';

  @override
  String get advancePaid => 'Advance Paid';

  @override
  String get advancePayAmountPer => 'Advance Pay Amount (%)';

  @override
  String get enablePrePayment => 'Enable Pre-Payment';

  @override
  String get enablePrePaymentMessage => 'This enables the service to be paid for in advance';

  @override
  String get invalidInput => 'Invalid input';

  @override
  String get remainingAmount => 'Remaining Amount';

  @override
  String get advancePayment => 'Advance Payment';

  @override
  String get valueConditionMessage => 'Value should be in 0 to 99';

  @override
  String get withExtraAndAdvanceCharge => 'With Extra charge and Advance payment';

  @override
  String get withExtraCharge => 'With Extra Charge';

  @override
  String get min => 'min';

  @override
  String get hour => 'hour';

  @override
  String get lblChangeCountry => "Change Country";

  @override
  String get lblExample => "Example";

  @override
  String get active => 'Active';

  @override
  String get inactive => 'Inactive';

  @override
  String get use24HourFormat => 'Use 24-hour format?';

  @override
  String get successfullyActivated => 'is successfully activated';

  @override
  String get providerHome => 'Provider Home';

  @override
  String get handymanHome => 'Handyman Home';

  @override
  String get home => 'Home';

  @override
  String get selectPlanSubTitle => 'Choose a plan tailored to your needs';

  @override
  String get userRole => 'User Role';

  @override
  String get paymentHistory => 'Payment History';

  @override
  String get theService => 'the service';

  @override
  String get selectDuration => 'Select Duration';

  @override
  String get thisServiceMayTake => 'This service may take';

  @override
  String get priceAmountValidationMessage => 'Price amount should be greater than 0';

  @override
  String get lblFeatureBlog => 'This is featured Blog';

  @override
  String get changePasswordTitle => 'Your new password must be different from previous used password';

  @override
  String get forgotPasswordSubtitle => 'A reset password link will be sent to the above entered email address';

  @override
  String get badRequest => '400: Bad Request';

  @override
  String get forbidden => '403: Forbidden';

  @override
  String get pageNotFound => '404: Page Not Found';

  @override
  String get tooManyRequests => '429: Too Many Requests';

  @override
  String get internalServerError => '500: Internal Server Error';

  @override
  String get badGateway => '502: Bad Gateway';

  @override
  String get serviceUnavailable => '503: Service Unavailable';

  @override
  String get gatewayTimeout => '504: Gateway Timeout';

  @override
  String get requested => 'Requested';

  @override
  String get assigned => 'Assigned';

  @override
  String get reload => 'Reload';

  @override
  String get noConversationSubTitle => "You didn't made any conversation yet";

  @override
  String get noServiceAccordingToCoordinates => 'Could not find any result for the supplied address or coordinates';

  @override
  String get isNotValid => 'is not valid';

  @override
  String get unlimited => 'Unlimited';

  @override
  String get upTo => 'upto';

  // NEW
  @override
  String get amountToBeReceived => "Amount to be received";

  @override
  String get yourCashPaymentForBookingId => "Your Cash Payment for";

  @override
  String get isAcceptedAsOn => "is Accepted as on";

  @override
  String get sendCashToProvider => "Send Cash to Provider";

  @override
  String get sendCashToAdmin => "Send Cash to Admin";

  @override
  String get cashPaymentApproval => "Cash Payment Approval";

  @override
  String get approvedByHandyman => "Approved by Handyman";

  @override
  String get sentToProvider => "Sent to Provider";

  @override
  String get pendingByProvider => "Pending by Provider";

  @override
  String get approvedByProvider => "Approved by Provider";

  @override
  String get pendingByAdmin => "Pending by Admin";

  @override
  String get approvedByAdmin => "Approved by Admin";

  @override
  String get sentToAdmin => "Sent to Admin";

  @override
  String get ofTransfer => "of Transfer";

  @override
  String get refNumber => "Ref. Number";

  @override
  String get todaySEarning => "Today's Earning";

  @override
  String get cash => "Cash";

  @override
  String get bank => "Bank";

  @override
  String get handymanApprovedTheRequest => "Handyman approved the request";

  @override
  String get requestSentToTheProvider => "Request sent to the provider";

  @override
  String get requestSentToTheAdmin => "Request sent to the admin";

  @override
  String get requestPendingWithTheProvider => "Request pending with the provider";

  @override
  String get providerApprovedTheRequest => "Provider approved the request";

  @override
  String get requestPendingWithTheAdmin => "Request pending with the admin";

  @override
  String get adminApprovedTheRequest => "Admin approved the request";

  @override
  String get today => "Today";

  @override
  String get yesterday => "Yesterday";

  @override
  String get customDate => "Custom Date";

  @override
  String get totalCash => "Total Cash in Hand";

  @override
  String get tomorrow => "Tomorrow";

  @override
  String get cashList => "Cash List";

  @override
  String get sortBy => "Sort by";

  @override
  String get noPaymentsFounds => "No Payments founds";

  @override
  String get cashBalance => "Cash Balance";

  @override
  String get close => "Close";

  @override
  String get retryPaymentDetails => "Retry Payment Details";

  @override
  String get totalAmountToPay => "Total Amount to Pay";

  @override
  String get from => "From";

  @override
  String get booking => "Booking";

  @override
  String get choosePaymentMethod => "Choose Payment Method";

  @override
  String get sendToAdmin => "Send To Admin";

  @override
  String get sendToProvider => "Send to Provider";

  @override
  String get detailsOfTheBank => "Details of the bank";

  @override
  String get selectABankTransferMoneyAndEnterTheReferenceIDInTheTextFieldBelow => "Select a bank, transfer money, and enter the reference ID in the text field below.";

  @override
  String get noBanksAvailable => "No banks available";

  @override
  String get chooseCashOrContactAdminForBankInformation => "Choose cash or contact admin for bank information";

  @override
  String get bankName => "Bank Name";

  @override
  String get accountNumber => "Account number";

  @override
  String get iFSCCode => "IFSC code";

  @override
  String get bankAddress => "Bank address";

  @override
  String get pleaseWaitWhileWeLoadBankDetails => "Please wait while we load bank details...";

  @override
  String get cashPaymentConfirmation => "Cash Payment Confirmation";

  @override
  String get remark => "Remark";

  @override
  String get pleaseWaitWhileWeLoadChatDetails => "Please wait while we load chat details...";

  @override
  String get isNotAvailableForChat => "is not available for chat";

  @override
  String get connectWithFirebaseForChat => "Connect with firebase for chat";

  @override
  String get admin => 'Admin';

  @override
  String get cashStatus => 'Cash Status';

  @override
  String get closeApp => 'Close App';

  @override
  String get youMustProvideValidCurrentPassword => 'You must provide a valid current password';

  @override
  String get selectUserType => 'Select User Type';

  @override
  String get pleaseSelectCommission => 'Please select commission';

  @override
  String get copied => 'Copied';

  @override
  String get pleaseContactYourAdmin => 'Your account is inactive. Please contact system administrator.';

  @override
  String get search => 'Search';

  @override
  String get wouldYouLikeToAssignThisBooking => 'Would you like to assign this booking?';

  @override
  String get connect => 'Connect';

  @override
  String get youAreNotConnectedWithChatServer => 'Connect to Chat Server';

  @override
  String get tapBelowButtonToConnectWithOurChatServer => 'You are not connected to the chat server. Tap the button below to connect and start chatting';

  @override
  String get transactionId => 'Transaction ID';

  @override
  String get appliedTaxes => 'Applied Taxes';

  @override
  String get by => 'by';

  @override
  String get thisOrderWillBe => 'This order will be marked as completed. Would you like to proceed?';

  @override
  String get externalWallet => 'External Wallet';

  @override
  String get start => 'Start';

  @override
  String get digitalService => 'Digital Service';

  @override
  String get digitalServiceSwitchSubText => 'Digital service booking with instant status updates in short process for direct interactions';

  @override
  String get filterAtLeastOneBookingStatusToast => 'Please ensure you pick at least one Booking Status';

  @override
  String get apply => 'Apply';

  @override
  String get clearFilter => 'Clear Filter';

  @override
  String get bookingStatus => 'Booking Status';

  @override
  String get filterBy => 'Filter By';

  @override
  String get cinetpayIsnTSupportedByCurrencies => "CinetPay isn't supported by your Currencies";

  @override
  String get totalAmountShouldBeMoreThan => 'Total amount should be more than';

  @override
  String get totalAmountShouldBeLessThan => 'Total amount should be less than';

  @override
  String get pleaseNoteThatAllServiceMarkedCompleted => 'Please Note That all service add-ons marked as completed!';

  @override
  String get serviceVisitType => 'Service Visit Type';

  @override
  String get thisServiceIsOnlineRemote => 'This service will be completed Online/Remotely.';

  @override
  String get visitOption => 'Visit Option';

  @override
  String get onSiteVisit => 'On-Site Visit';

  @override
  String get onlineRemoteService => 'Online/Remote Service';

  @override
  String get addOns => 'Add-ons';

  @override
  String get serviceAddOns => 'Service Add-ons';

  @override
  String get writeHere => 'Write Here';

  @override
  String get writeShortLineAbout => 'Write short line about, Why Choose Me?';

  @override
  String get reasonsToChooseYour => 'Reasons to choose your service';

  @override
  String get addReasons => 'Add Reasons';

  @override
  String get addReason => 'Add Reason';

  @override
  String get writeReason => 'write reason';

  @override
  String get pleaseAddReason => 'Please add Reason!';

  @override
  String get isAvailableGoTo => 'is available. Go to Play Store and Download the New Version of the App.';

  @override
  String get later => 'Later';

  @override
  String get addonServices => 'Addon Services';

  @override
  String get paymentSuccess => 'Payment Success';

  @override
  String get redirectingToBookings => 'Redirecting to bookings..';

  @override
  String get transactionIsInProcess => 'Transaction is in process...';

  @override
  String get pleaseCheckThePayment => 'Please check the payment request is sent to your number';

  @override
  String get enterYourMsisdnHere => 'Enter your msisdn here';

  @override
  String get theTransactionIsStill => 'The transaction is still processing and is in ambiguous state. Please do the transaction enquiry to fetch the transaction status.';

  @override
  String get transactionIsSuccessful => 'Transaction is successful';

  @override
  String get incorrectPinHasBeen => 'Incorrect Pin has been entered';

  @override
  String get theUserHasExceeded => 'The User has exceeded their wallet allowed transaction limit';

  @override
  String get theAmountUserIs => 'The amount User is trying to transfer is less than the minimum amount allowed';

  @override
  String get userDidnTEnterThePin => "User didn't enter the pin";

  @override
  String get transactionInPendingState => 'Transaction in pending state. Please check after sometime';

  @override
  String get userWalletDoesNot => 'User wallet does not have enough money to cover the payable amount';

  @override
  String get theTransactionWasRefused => 'The transaction was refused';

  @override
  String get thisIsAGeneric => 'This is a generic refusal that has several possible causes';

  @override
  String get payeeIsAlreadyInitiated => 'Payee is already initiated for churn or barred or not registered on Airtel Money platform';

  @override
  String get theTransactionWasTimed => 'The transaction was timed out.';

  @override
  String get theTransactionWasNot => 'The transaction was not found.';

  @override
  String get xSignatureAndPayloadDid => 'x-signature and payload did not match';

  @override
  String get encryptionKeyHasBeen => 'Encryption key has been fetched successfully';

  @override
  String get couldNotFetchEncryption => 'Could not fetch encryption key';

  @override
  String get transactionHasBeenExpired => 'Transaction has been expired';

  @override
  String get airtelMoneyPayment => 'Airtel Money Payment';

  @override
  String get addonServiceName => 'Addon Service Name';

  @override
  String get editAddonService => 'Edit Addon Service';

  @override
  String get addAddonService => 'Add Addon Service';

  @override
  String get noteYouCanUpload => 'Note: You can upload image with \'jpg\', \'png\', \'jpeg\' extensions & you can select only one image';

  @override
  String get oppsLooksLikeYou => 'Opps! looks like you have not added any Add-ons Services yet.';

  @override
  String get ambiguous => 'Ambiguous';

  @override
  String get success => 'Success';

  @override
  String get incorrectPin => 'Incorrect Pin';

  @override
  String get exceedsWithdrawalAmountLimitS => 'Exceeds withdrawal amount limit(s) / Withdrawal amount limit exceeded';

  @override
  String get invalidAmount => 'Invalid Amount';

  @override
  String get transactionIdIsInvalid => 'Transaction ID is invalid';

  @override
  String get inProcess => 'In process';

  @override
  String get notEnoughBalance => 'Not enough balance';

  @override
  String get refused => 'Refused';

  @override
  String get doNotHonor => 'Do not honor';

  @override
  String get transactionNotPermittedTo => 'Transaction not permitted to Payee';

  @override
  String get transactionTimedOut => 'Transaction Timed Out';

  @override
  String get transactionNotFound => 'Transaction Not Found';

  @override
  String get forBidden => 'Forbidden';

  @override
  String get successfullyFetchedEncryptionKey => 'Successfully fetched Encryption Key';

  @override
  String get errorWhileFetchingEncryption => 'Error while fetching encryption key';

  @override
  String get transactionExpired => 'Transaction Expired';

  @override
  String get pleaseSelectAService => 'Please select a service';

  @override
  String get verifyEmail => 'Verify Email';

  @override
  String get verified => 'Verified';

  @override
  String get minRead => 'min read';

  @override
  String get loadingChats => 'Loading chats...';

  @override
  String get monthly => 'Monthly';

  @override
  String get mon => 'Mon';

  @override
  String get tue => 'Tue';

  @override
  String get wed => 'Wed';

  @override
  String get thu => 'Thu';

  @override
  String get fri => 'Fri';

  @override
  String get sat => 'Sat';

  @override
  String get sun => 'Sun';

  @override
  String get jan => 'Jan';

  @override
  String get feb => 'Feb';

  @override
  String get mar => 'Mar';

  @override
  String get apr => 'Apr';

  @override
  String get may => 'May';

  @override
  String get jun => 'Jun';

  @override
  String get july => 'July';

  @override
  String get aug => 'Aug';

  @override
  String get sept => 'Sept';

  @override
  String get oct => 'Oct';

  @override
  String get nov => 'Nov';

  @override
  String get dec => 'Dec';

  @override
  String get pushNotification => 'Push Notification';

  @override
  String get sentYouAMessage => 'sent you a message';

  @override
  String get deleteMessage => 'Delete Message';

  @override
  String get removeThisFile => 'Remove This File';

  @override
  String get areYouSureWantToRemoveThisFile => 'Are you sure want to remove this file?';

  @override
  String get sendMessage => 'Send Message';

  @override
  String get handymanLocation => 'Handyman Location';

  @override
  String get track => 'Track';

  @override
  String get trackHandymanLocation => 'Track Handyman Location';

  @override
  String get lastUpdatedAt => 'Last updated at:';

  String get lblBankDetails => "Bank Details";

  @override
  String get withdraw => "Withdraw";

  @override
  String get availableBalance => "Available Balance";

  @override
  String get withdrawRequest => "Withdraw Request";

  @override
  String get chooseBank => "Choose Bank";

  @override
  String get egCentralNationalBank => 'eg" central national bank"';

  @override
  String get addBank => "Add bank";

  @override
  String get successful => 'Successful';

  @override
  String get yourWithdrawalRequestHasBeenSuccessfullySubmitted => 'Your withdrawal request has been successfully submitted.';

  @override
  String get done => "Done";

  @override
  String get requestList => "Request List";

  @override
  String get filter => 'Filter';

  @override
  String get reset => "Reset";

  @override
  String get bankList => "Bank List";

  @override
  String get lbldefault => "Default";

  @override
  String get setAsDefault => "Set as default";

  @override
  String get branchName => "Branch Name";

  @override
  String get aadharNumber => "Aadhar Number";

  @override
  String get panNumber => "PAN Number";

  @override
  String get lblPleaseEnterAccountNumber => "Please Enter Account Number";

  @override
  String get lblAccountNumberMustContainOnlyDigits => "Account number must contain only digits";

  @override
  String get lblAccountNumberMustBetween11And16Digits => "Account number must be between 11 and 16 digits";

  @override
  String get noBankDataTitle => "No Bank Data Found";

  @override
  String get noBankDataSubTitle => "You didn't add bank yet";

  @override
  String get eg3000 => 'eg" 3000"';

  @override
  String get pleaseAddLessThanOrEqualTo => "Please add less than or equal to";

  @override
  String get deleteBankTitle => 'Are you sure want to delete this Bank?';

  @override
  String get debit => 'Debit';

  @override
  String get credit => 'Credit';

  @override
  String get fullNameOnBankAccount => 'Full name on bank account';

  @override
  String get updateYourLocation => 'Update your location';

  @override
  String get lbHours => "Hours";

  @override
  String get lbMinutes => "Minutes";

  @override
  String get handymanCommission => 'Handyman Commission';

  @override
  String get commission => 'Commission';

  @override
  String get noCommissionTypeListFound => 'No Commission Type List Found';

  @override
  String get typeName => 'Type Name';

  @override
  String get addHandymanCommission => 'Add Handyman Commission';

  @override
  String get editHandymanCommission => 'Edit Handyman Commission';

  @override
  String get enterValidCommissionValue => 'Enter Valid Commission Value';

  @override
  String get percentage => 'Percentage';

  @override
  String get selectStatus => 'Select Status';

  @override
  String get youCanTUpdateDeleted => "You can't update deleted items";

  @override
  String get thisCommissionHasBeen => 'This commission has been created by the admin.';

  @override
  String get copyMessage => 'Copy Message';

  @override
  String get transactions => 'Transactions';

  @override
  String get thisYear => 'This Year';

  @override
  String get thisMonth => 'This Month';

  @override
  String get thisWeek => 'This Week';

  @override
  String get providerList => 'Provider List';

  @override
  String get walletBalance => 'Wallet Balance';

  @override
  String get remainingPayout => 'Remaining Payout';

  @override
  String get totalRevenue => 'Total Revenue';

  @override
  String get totalActiveCount => 'Total Active Count:';

  @override
  String get completedBookings => 'Completed Bookings';

  @override
  String get pickAProviderYou => 'Pick A provider you wish to work with';

  @override
  String get selectedProvider => 'Selected Provider';

  @override
  String get youHavePermanentlyDenied => 'You have permanently denied location permission please allow for live location tracking from your settings';

  @override
  String get open => 'OPEN';

  @override
  String get closed => 'CLOSED';

  @override
  String get createBy => 'Create by';

  @override
  String get repliedBy => 'Replied by';

  @override
  String get closedBy => 'Closed by';

  @override
  String get helpDesk => 'Help Desk';

  @override
  String get addNew => 'Add New';

  @override
  String get queryYet => 'Query Yet';

  @override
  String get toSubmitYourProblems => 'To submit your problems simply press add button and explain your concern';

  @override
  String get noRecordsFoundFor => 'No records found for';

  @override
  String get queries => 'queries.';

  @override
  String get noActivityYet => 'No Activity Yet';

  @override
  String get noRecordsFound => 'No records found';

  @override
  String get reply => 'Reply';

  @override
  String get eGDuringTheService => 'e.g. During the service, the furniture was accidentally damaged.';

  @override
  String get doYouWantClosedThisQuery => 'Do you want closed this query';

  @override
  String get markAsClosed => 'Mark as Closed';

  @override
  String get youCanMarkThis => 'You can mark this as closed if you are satisfied with our answer';

  @override
  String get subject => 'Subject';

  @override
  String get eGDamagedFurniture => 'e.g. Damaged furniture';

  @override
  String get closedOn => 'Closed on:';

  @override
  String get on => 'on';

  @override
  String get showMessage => 'Show Message';

  @override
  String get viewDetail => 'View Detail';

  @override
  String get serviceProofMediaUploadNote => 'Note : You can Upload Image with “JPG” , ‘PNG”, “JPEG” extension and you can select multiple images';

  @override
  String get uploadMedia => 'Upload Media';

  @override
  String get viewStatus => 'View Status';

  @override
  String get email => 'Email:';

  @override
  String get at => 'at';

  @override
  String get general => 'GENERAL';

  @override
  String get other => 'OTHER';

  @override
  String get setting => 'SETTING';

  @override
  String get viewBreakdown => 'View Breakdown';

  @override
  String get totalAmount => 'Total Amount:';

  @override
  String get role => 'ROLE';

  @override
  String get paymentBreakdown => 'Payment Breakdown';

  @override
  String get paymentType => 'Payment Type';

  @override
  String get dateRange => 'Date Range';

  @override
  String get providerNotFound => 'Provider Not Found';

  @override
  String get noPaymentMethodsFound => 'No Payment Methods Found';

  @override
  String get handymanNotFound => 'Handyman Not Found';

  @override
  String get selectStartDateEndDate => 'Select start date & end date';

  @override
  String get customerNotFound => 'Customer Not Found';

  @override
  String get to => 'to';

  @override
  String get chooseYourDateRange => 'Choose your Date Range';

  @override
  String get advancedRefund => 'Advanced Refund';

  @override
  String get taxAmount => 'Tax Amount';

  @override
  String get lblReassign => 'Reassign';

  @override
  String get handymanPayoutList => 'Handyman Payout List';

  @override
  String get earningDetails => 'Earning Details';

  @override
  String get adminEarning => 'Admin Earning';

  @override
  String get handymanName => 'Handyman Name';

  @override
  String get totalEarning => 'Total Earning';

  @override
  String get myEarning => 'My Earning';

  @override
  String get handymanPayDue => 'Handyman Pay Due';

  @override
  String get handymanPaidAmount => 'Handyman Paid Amount';

  @override
  String get payout => 'Payout';

  @override
  String get addHandymanPayout => 'Add Handyman Payout';

  @override
  String get selectMethod => 'Select Method';

  @override
  String get handymanEarning => 'Handyman Earning';

  @override
  String get handymanEarnings => 'Handyman Earnings';

  @override
  String get noPayoutFound => 'No Payout Found';

  @override
  String get handymanEarningList => 'Handyman Earning List';

  @override
  String get permissionDeniedUnableTo => 'Permission denied! Unable to edit Handyman';

  @override
  String get passwordLengthShouldBe => 'Password length should be 8 to 12 characters.';

  @override
  String get promotionalBanners => 'Promotional Banners';

  @override
  String get chooseAnyOnePayment => 'Choose any one payment method first';

  @override
  String get thisBannerIsCurrently => 'This banner is currently under admin review.';

  @override
  String get doYouWantToDeleteBanner => 'Do you want to delete this banner';

  @override
  String get link => 'Link';

  @override
  String get youHaveAnInsufficient => 'You have an insufficient balance in your wallet. Please choose another method.';

  @override
  String get addPromotionalBanner => 'Add Promotional Banner';

  @override
  String promoteYourBusinessBanners(String perDayAmount) => 'Promote your business banners in $perDayAmount/day.!';

  @override
  String get advertiseYourServicesEffectively => 'Advertise your services effectively and drive more engagement today.';

  @override
  String get shortDescription => 'Short Description';

  @override
  String get eGHandymanTrustedService => 'e.g. Handyman trusted service';

  @override
  String get chooseService => 'Choose Service';

  @override
  String get enterLink => 'Enter Link';

  @override
  String get eGHttpsWwwYourlinkCom => 'e.g. https://www.yourlink.com';

  @override
  String daysSelected(String totalDaysCount) => '$totalDaysCount days selected';

  @override
  String get promotionalBannerDetail => 'Promotional Banner Detail';

  @override
  String get promotionalBanner => 'Promotional Banner';

  @override
  String promotionalBannerYet(String name) => 'No $name Promotional Banner Yet';

  @override
  String get toSubmitYourBanner => 'To submit your banner simply press add button and upload your promotional banner';

  @override
  String get canTFindRevenuecatProduct => "Can't find revenueCat product";

  @override
  String get waitForAWhile => "Wait for a while we're saving your subscription";

  @override
  String get reason => 'Reason:';

  @override
  String get type => 'Type:';

  @override
  String noRecordsFoundForBanner(String status) => 'No records found for $status Promotional Banners';

  @override
  String get noPromotionalBannerYet => 'No Promotional Banner Yet';

  @override
  String get note => 'Note: ';

  @override
  String get pay => 'Pay';

  @override
  String get selecteDateNote => 'This banner will be displayed to users from {startDate} to {endDate}.';
}