{{ html()->form('POST', route('seosetting'))->attribute('enctype', 'multipart/form-data')->attribute('data-toggle', 'validator')->open() }}

{{ html()->hidden('id',$seosetting->id ?? null)->class('form-control')->placeholder('id') }}
{{ html()->hidden('page')->value($page)->class('form-control')->placeholder('id') }}

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">SEO Settings</h4>
            </div>
            <div class="card-body">
                <!-- Basic SEO Settings -->
                <div class="row">
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">Meta Title</label>
                            <div class="col-sm-12">
                                {{ html()->text('meta_title', $seosetting->meta_title ?? '')->class('form-control')->placeholder('Enter meta title')->id('meta_title') }}
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">Meta Keywords</label>
                            <div class="col-sm-12">
                                @php
                                    $keywords = '';
                                    if(isset($seosetting->meta_keywords) && is_array($seosetting->meta_keywords)) {
                                        $keywords = implode(', ', $seosetting->meta_keywords);
                                    }
                                @endphp
                                {{ html()->text('meta_keywords', $keywords)->class('form-control')->placeholder('Enter keywords separated by commas')->id('meta_keywords') }}
                                <small class="form-text text-muted">Enter multiple keywords separated by commas (e.g., handyman, repair, service)</small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">Meta Description</label>
                            <div class="col-sm-12">
                                {{ html()->textarea('meta_description', $seosetting->meta_description ?? '')->class('form-control textarea')->rows(3)->placeholder('Enter meta description')->id('meta_description') }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">Site Meta Description</label>
                            <div class="col-sm-12">
                                {{ html()->textarea('site_meta_description', $seosetting->site_meta_description ?? '')->class('form-control textarea')->rows(3)->placeholder('Enter site meta description')->id('site_meta_description') }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">Global Canonical URL</label>
                            <div class="col-sm-12">
                                {{ html()->text('global_canonical_url', $seosetting->global_canonical_url ?? '')->class('form-control')->placeholder('Enter global canonical URL')->id('global_canonical_url') }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">Google Site Verification</label>
                            <div class="col-sm-12">
                                {{ html()->text('google_site_verification', $seosetting->google_site_verification ?? '')->class('form-control')->placeholder('Enter Google site verification code')->id('google_site_verification') }}
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <label for="" class="col-sm-6 form-control-label">SEO Image</label>
                            <div class="col-sm-12">
                                <input type="file" name="seo_image" class="form-control" accept="image/*">
                                @if(isset($seosetting) && $seosetting->getFirstMediaUrl('seo_image'))
                                    <div class="mt-2">
                                        <img src="{{ $seosetting->getFirstMediaUrl('seo_image') }}" alt="SEO Image" class="img-thumbnail" style="max-width: 200px;">
                                        <br>
                                        <small class="text-muted">Current SEO Image</small>
                                    </div>
                                @endif
                                <small class="form-text text-muted">Upload an image for SEO purposes (recommended size: 1200x630px)</small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-lg-12">
                        <div class="form-group">
                            <div class="col-md-offset-3 col-sm-12 ">
                                {{ html()->submit(__('messages.save'))->class('btn btn-md btn-primary float-md-right') }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{ html()->form()->close() }}